/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.query.internal;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan.exec.internal.Helper;
import org.hibernate.loader.plan.exec.internal.LoadQueryBuilderHelper;
import org.hibernate.loader.plan.exec.process.internal.CollectionReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.EntityReferenceReader;
import org.hibernate.loader.plan.exec.query.internal.SelectStatementBuilder;
import org.hibernate.loader.plan.exec.query.spi.EntityLoadQueryBuilder;
import org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.hibernate.loader.plan.exec.spi.ReaderCollector;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.sql.DisjunctionFragment;
import org.hibernate.sql.InFragment;

public class EntityLoadQueryBuilderImpl
implements EntityLoadQueryBuilder {
    public static final EntityLoadQueryBuilderImpl INSTANCE = new EntityLoadQueryBuilderImpl();

    @Override
    public String generateSql(LoadPlan loadPlan, SessionFactoryImplementor factory, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext) {
        EntityReturn rootReturn = Helper.INSTANCE.extractRootReturn(loadPlan, EntityReturn.class);
        return this.generateSql(((Queryable)rootReturn.getEntityPersister()).getKeyColumnNames(), rootReturn, factory, buildingParameters, aliasResolutionContext);
    }

    @Override
    public String generateSql(String[] keyColumnNames, LoadPlan loadPlan, SessionFactoryImplementor factory, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext) {
        EntityReturn rootReturn = Helper.INSTANCE.extractRootReturn(loadPlan, EntityReturn.class);
        String[] keyColumnNamesToUse = keyColumnNames != null ? keyColumnNames : ((Queryable)rootReturn.getEntityPersister()).getIdentifierColumnNames();
        return this.generateSql(keyColumnNamesToUse, rootReturn, factory, buildingParameters, aliasResolutionContext);
    }

    protected String generateSql(String[] keyColumnNames, EntityReturn rootReturn, SessionFactoryImplementor factory, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext) {
        SelectStatementBuilder select = new SelectStatementBuilder(factory.getDialect());
        this.applyRootReturnSpecifics(select, keyColumnNames, rootReturn, factory, buildingParameters, aliasResolutionContext);
        LoadQueryBuilderHelper.applyJoinFetches(select, factory, rootReturn, buildingParameters, aliasResolutionContext, new ReaderCollector(){

            @Override
            public void addReader(CollectionReferenceReader collectionReferenceReader) {
            }

            @Override
            public void addReader(EntityReferenceReader entityReferenceReader) {
            }
        });
        return select.toStatementString();
    }

    protected void applyRootReturnSpecifics(SelectStatementBuilder select, String[] keyColumnNames, EntityReturn rootReturn, SessionFactoryImplementor factory, QueryBuildingParameters buildingParameters, AliasResolutionContext aliasResolutionContext) {
        String fromTableFragment;
        String rootAlias = aliasResolutionContext.resolveAliases(rootReturn).getTableAlias();
        OuterJoinLoadable rootLoadable = (OuterJoinLoadable)rootReturn.getEntityPersister();
        Queryable rootQueryable = (Queryable)rootReturn.getEntityPersister();
        this.applyKeyRestriction(select, rootAlias, keyColumnNames, buildingParameters.getBatchSize());
        select.appendRestrictions(rootQueryable.filterFragment(rootAlias, buildingParameters.getQueryInfluencers().getEnabledFilters()));
        select.appendRestrictions(rootLoadable.whereJoinFragment(rootAlias, true, true));
        select.appendSelectClauseFragment(rootLoadable.selectFragment(rootAlias, aliasResolutionContext.resolveAliases(rootReturn).getColumnAliases().getSuffix()));
        if (buildingParameters.getLockOptions() != null) {
            fromTableFragment = factory.getDialect().appendLockHint(buildingParameters.getLockOptions(), rootLoadable.fromTableFragment(rootAlias));
            select.setLockOptions(buildingParameters.getLockOptions());
        } else if (buildingParameters.getLockMode() != null) {
            fromTableFragment = factory.getDialect().appendLockHint(buildingParameters.getLockMode(), rootLoadable.fromTableFragment(rootAlias));
            select.setLockMode(buildingParameters.getLockMode());
        } else {
            fromTableFragment = rootLoadable.fromTableFragment(rootAlias);
        }
        select.appendFromClauseFragment(fromTableFragment + rootLoadable.fromJoinFragment(rootAlias, true, true));
    }

    private void applyKeyRestriction(SelectStatementBuilder select, String alias, String[] keyColumnNames, int batchSize) {
        if (keyColumnNames.length == 1) {
            InFragment in = new InFragment().setColumn(alias, keyColumnNames[0]);
            for (int i = 0; i < batchSize; ++i) {
                in.addValue("?");
            }
            select.appendRestrictions(in.toFragmentString());
        } else {
            ConditionFragment keyRestrictionBuilder = new ConditionFragment().setTableAlias(alias).setCondition(keyColumnNames, "?");
            String keyRestrictionFragment = keyRestrictionBuilder.toFragmentString();
            StringBuilder restrictions = new StringBuilder();
            if (batchSize == 1) {
                restrictions.append(keyRestrictionFragment);
            } else {
                restrictions.append('(');
                DisjunctionFragment df = new DisjunctionFragment();
                for (int i = 0; i < batchSize; ++i) {
                    df.addCondition(keyRestrictionFragment);
                }
                restrictions.append(df.toFragmentString());
                restrictions.append(')');
            }
            select.appendRestrictions(restrictions.toString());
        }
    }
}

