/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.process.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.hibernate.loader.plan.exec.process.internal.CollectionReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.EntityReferenceReader;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan.exec.spi.RowReader;

public abstract class AbstractRowReader
implements RowReader {
    @Override
    public Object readRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
        boolean hasCollectionReferenceReaders;
        List<EntityReferenceReader> entityReferenceReaders = this.getEntityReferenceReaders();
        List<CollectionReferenceReader> collectionReferenceReaders = this.getCollectionReferenceReaders();
        boolean hasEntityReferenceReaders = entityReferenceReaders != null && entityReferenceReaders.size() > 0;
        boolean bl = hasCollectionReferenceReaders = collectionReferenceReaders != null && collectionReferenceReaders.size() > 0;
        if (hasEntityReferenceReaders) {
            for (EntityReferenceReader entityReferenceReader : entityReferenceReaders) {
                entityReferenceReader.hydrateIdentifier(resultSet, context);
            }
            for (EntityReferenceReader entityReferenceReader : entityReferenceReaders) {
                entityReferenceReader.resolveEntityKey(resultSet, context);
            }
            for (EntityReferenceReader entityReferenceReader : entityReferenceReaders) {
                entityReferenceReader.hydrateEntityState(resultSet, context);
            }
        }
        Object logicalRow = this.readLogicalRow(resultSet, context);
        if (hasEntityReferenceReaders) {
            for (EntityReferenceReader entityReferenceReader : entityReferenceReaders) {
                entityReferenceReader.finishUpRow(resultSet, context);
            }
        }
        if (hasCollectionReferenceReaders) {
            for (CollectionReferenceReader collectionReferenceReader : collectionReferenceReaders) {
                collectionReferenceReader.finishUpRow(resultSet, context);
            }
        }
        return logicalRow;
    }

    protected abstract List<EntityReferenceReader> getEntityReferenceReaders();

    protected abstract List<CollectionReferenceReader> getCollectionReferenceReaders();

    protected abstract Object readLogicalRow(ResultSet var1, ResultSetProcessingContextImpl var2) throws SQLException;
}

