/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.internal;

import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.Return;

public class Helper {
    public static final Helper INSTANCE = new Helper();

    private Helper() {
    }

    public <T extends Return> T extractRootReturn(LoadPlan loadPlan, Class<T> returnType) {
        if (loadPlan.getReturns().size() == 0) {
            throw new IllegalStateException("LoadPlan contained no root returns");
        }
        if (loadPlan.getReturns().size() > 1) {
            throw new IllegalStateException("LoadPlan contained more than one root returns");
        }
        Return rootReturn = loadPlan.getReturns().get(0);
        if (!returnType.isInstance(rootReturn)) {
            throw new IllegalStateException(String.format("Unexpected LoadPlan root return; expecting %s, but found %s", returnType.getName(), rootReturn.getClass().getName()));
        }
        return (T)rootReturn;
    }
}

