/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.NameGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.plan.exec.internal.EntityReferenceAliasesImpl;
import org.hibernate.loader.plan.exec.spi.AliasResolutionContext;
import org.hibernate.loader.plan.exec.spi.CollectionReferenceAliases;
import org.hibernate.loader.plan.exec.spi.EntityReferenceAliases;
import org.hibernate.loader.plan.spi.AnyFetch;
import org.hibernate.loader.plan.spi.BidirectionalEntityFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CompositeElementGraph;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.CompositeIndexGraph;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.Fetch;
import org.hibernate.loader.plan.spi.FetchOwner;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.ScalarReturn;
import org.hibernate.loader.plan.spi.SourceQualifiable;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.EntityType;
import org.jboss.logging.Logger;

public class AliasResolutionContextImpl
implements AliasResolutionContext {
    private static final Logger log = CoreLogging.logger(AliasResolutionContextImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final Map<Return, String> sourceAliasByReturnMap;
    private final Map<SourceQualifiable, String> sourceQualifiersByReturnMap;
    private final Map<EntityReference, EntityReferenceAliasesImpl> aliasesByEntityReference = new HashMap<EntityReference, EntityReferenceAliasesImpl>();
    private final Map<CollectionReference, LoadQueryCollectionAliasesImpl> aliasesByCollectionReference = new HashMap<CollectionReference, LoadQueryCollectionAliasesImpl>();
    private final Map<JoinableAssociation, JoinableAssociationAliasesImpl> aliasesByJoinableAssociation = new HashMap<JoinableAssociation, JoinableAssociationAliasesImpl>();
    private int currentAliasSuffix;
    private int currentTableAliasUniqueness;

    public AliasResolutionContextImpl(SessionFactoryImplementor sessionFactory) {
        this(sessionFactory, 0);
    }

    public AliasResolutionContextImpl(SessionFactoryImplementor sessionFactory, int suffixSeed) {
        this(sessionFactory, suffixSeed, Collections.emptyMap(), Collections.emptyMap());
    }

    public AliasResolutionContextImpl(SessionFactoryImplementor sessionFactory, int suffixSeed, Map<Return, String> sourceAliasByReturnMap, Map<SourceQualifiable, String> sourceQualifiersByReturnMap) {
        this.sessionFactory = sessionFactory;
        this.currentAliasSuffix = suffixSeed;
        this.sourceAliasByReturnMap = new HashMap<Return, String>(sourceAliasByReturnMap);
        this.sourceQualifiersByReturnMap = new HashMap<SourceQualifiable, String>(sourceQualifiersByReturnMap);
    }

    @Override
    public String getSourceAlias(Return theReturn) {
        return this.sourceAliasByReturnMap.get(theReturn);
    }

    @Override
    public String[] resolveScalarColumnAliases(ScalarReturn scalarReturn) {
        int numberOfColumns = scalarReturn.getType().getColumnSpan(this.sessionFactory);
        String sourceAlias = this.getSourceAlias(scalarReturn);
        if (sourceAlias != null) {
            return NameGenerator.scalarNames(sourceAlias, numberOfColumns);
        }
        return NameGenerator.scalarNames(this.currentAliasSuffix++, numberOfColumns);
    }

    @Override
    public EntityReferenceAliases resolveAliases(EntityReference entityReference) {
        EntityReferenceAliasesImpl aliases = this.aliasesByEntityReference.get(entityReference);
        if (aliases == null) {
            if (BidirectionalEntityFetch.class.isInstance(entityReference)) {
                return this.resolveAliases(((BidirectionalEntityFetch)((Object)entityReference)).getTargetEntityReference());
            }
            EntityPersister entityPersister = entityReference.getEntityPersister();
            aliases = new EntityReferenceAliasesImpl(this.createTableAlias(entityPersister), this.createEntityAliases(entityPersister));
            this.aliasesByEntityReference.put(entityReference, aliases);
        }
        return aliases;
    }

    @Override
    public CollectionReferenceAliases resolveAliases(CollectionReference collectionReference) {
        LoadQueryCollectionAliasesImpl aliases = this.aliasesByCollectionReference.get(collectionReference);
        if (aliases == null) {
            CollectionPersister collectionPersister = collectionReference.getCollectionPersister();
            aliases = new LoadQueryCollectionAliasesImpl(this.createTableAlias(collectionPersister.getRole()), collectionPersister.isManyToMany() ? this.createTableAlias(collectionPersister.getRole()) : null, this.createCollectionAliases(collectionPersister), this.createCollectionElementAliases(collectionPersister));
            this.aliasesByCollectionReference.put(collectionReference, aliases);
        }
        return aliases;
    }

    @Override
    public String resolveAssociationRhsTableAlias(JoinableAssociation joinableAssociation) {
        return this.getOrGenerateJoinAssocationAliases(joinableAssociation).rhsAlias;
    }

    @Override
    public String resolveAssociationLhsTableAlias(JoinableAssociation joinableAssociation) {
        return this.getOrGenerateJoinAssocationAliases(joinableAssociation).lhsAlias;
    }

    @Override
    public String[] resolveAssociationAliasedLhsColumnNames(JoinableAssociation joinableAssociation) {
        return this.getOrGenerateJoinAssocationAliases(joinableAssociation).aliasedLhsColumnNames;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    private String createSuffix() {
        return Integer.toString(this.currentAliasSuffix++) + '_';
    }

    private JoinableAssociationAliasesImpl getOrGenerateJoinAssocationAliases(JoinableAssociation joinableAssociation) {
        JoinableAssociationAliasesImpl aliases = this.aliasesByJoinableAssociation.get(joinableAssociation);
        if (aliases == null) {
            String rhsAlias;
            String lhsAlias;
            Fetch currentFetch = joinableAssociation.getCurrentFetch();
            if (AnyFetch.class.isInstance(currentFetch)) {
                throw new WalkingException("Any type should never be joined!");
            }
            if (EntityReference.class.isInstance(currentFetch.getOwner())) {
                lhsAlias = this.resolveAliases((EntityReference)((Object)currentFetch.getOwner())).getTableAlias();
            } else if (CompositeFetch.class.isInstance(currentFetch.getOwner())) {
                lhsAlias = this.resolveAliases(this.locateCompositeFetchEntityReferenceSource((CompositeFetch)currentFetch.getOwner())).getTableAlias();
            } else if (CompositeElementGraph.class.isInstance(currentFetch.getOwner())) {
                CompositeElementGraph compositeElementGraph = (CompositeElementGraph)currentFetch.getOwner();
                lhsAlias = this.resolveAliases(compositeElementGraph.getCollectionReference()).getElementTableAlias();
            } else if (CompositeIndexGraph.class.isInstance(currentFetch.getOwner())) {
                CompositeIndexGraph compositeIndexGraph = (CompositeIndexGraph)currentFetch.getOwner();
                lhsAlias = this.resolveAliases(compositeIndexGraph.getCollectionReference()).getElementTableAlias();
            } else {
                throw new NotYetImplementedException("Cannot determine LHS alias for FetchOwner.");
            }
            String[] aliasedLhsColumnNames = currentFetch.toSqlSelectFragments(lhsAlias);
            if (EntityReference.class.isInstance(currentFetch)) {
                rhsAlias = this.resolveAliases((EntityReference)((Object)currentFetch)).getTableAlias();
            } else if (CollectionReference.class.isInstance(joinableAssociation.getCurrentFetch())) {
                rhsAlias = this.resolveAliases((CollectionReference)((Object)currentFetch)).getCollectionTableAlias();
            } else {
                throw new NotYetImplementedException("Cannot determine RHS alis for a fetch that is not an EntityReference or CollectionReference.");
            }
            aliases = new JoinableAssociationAliasesImpl(lhsAlias, aliasedLhsColumnNames, rhsAlias);
            this.aliasesByJoinableAssociation.put(joinableAssociation, aliases);
        }
        return aliases;
    }

    private EntityReference locateCompositeFetchEntityReferenceSource(CompositeFetch composite) {
        FetchOwner owner = composite.getOwner();
        if (EntityReference.class.isInstance(owner)) {
            return (EntityReference)((Object)owner);
        }
        if (CompositeFetch.class.isInstance(owner)) {
            return this.locateCompositeFetchEntityReferenceSource((CompositeFetch)owner);
        }
        throw new WalkingException("Cannot resolve entity source for a CompositeFetch");
    }

    private String createTableAlias(EntityPersister entityPersister) {
        return this.createTableAlias(StringHelper.unqualifyEntityName(entityPersister.getEntityName()));
    }

    private String createTableAlias(String name) {
        return StringHelper.generateAlias(name, this.currentTableAliasUniqueness++);
    }

    private EntityAliases createEntityAliases(EntityPersister entityPersister) {
        return new DefaultEntityAliases((Loadable)entityPersister, this.createSuffix());
    }

    private CollectionAliases createCollectionAliases(CollectionPersister collectionPersister) {
        return new GeneratedCollectionAliases(collectionPersister, this.createSuffix());
    }

    private EntityAliases createCollectionElementAliases(CollectionPersister collectionPersister) {
        if (!collectionPersister.getElementType().isEntityType()) {
            return null;
        }
        EntityType entityElementType = (EntityType)collectionPersister.getElementType();
        return this.createEntityAliases((EntityPersister)((Object)entityElementType.getAssociatedJoinable(this.sessionFactory())));
    }

    private static class JoinableAssociationAliasesImpl {
        private final String lhsAlias;
        private final String[] aliasedLhsColumnNames;
        private final String rhsAlias;

        public JoinableAssociationAliasesImpl(String lhsAlias, String[] aliasedLhsColumnNames, String rhsAlias) {
            this.lhsAlias = lhsAlias;
            this.aliasedLhsColumnNames = aliasedLhsColumnNames;
            this.rhsAlias = rhsAlias;
        }
    }

    private static class LoadQueryCollectionAliasesImpl
    implements CollectionReferenceAliases {
        private final String tableAlias;
        private final String manyToManyAssociationTableAlias;
        private final CollectionAliases collectionAliases;
        private final EntityAliases entityElementAliases;

        public LoadQueryCollectionAliasesImpl(String tableAlias, String manyToManyAssociationTableAlias, CollectionAliases collectionAliases, EntityAliases entityElementAliases) {
            this.tableAlias = tableAlias;
            this.manyToManyAssociationTableAlias = manyToManyAssociationTableAlias;
            this.collectionAliases = collectionAliases;
            this.entityElementAliases = entityElementAliases;
        }

        @Override
        public String getCollectionTableAlias() {
            return StringHelper.isNotEmpty(this.manyToManyAssociationTableAlias) ? this.manyToManyAssociationTableAlias : this.tableAlias;
        }

        @Override
        public String getElementTableAlias() {
            return this.tableAlias;
        }

        @Override
        public CollectionAliases getCollectionColumnAliases() {
            return this.collectionAliases;
        }

        @Override
        public EntityAliases getEntityElementColumnAliases() {
            return this.entityElementAliases;
        }
    }
}

