/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public abstract class BasicConnectionCreator
implements ConnectionCreator {
    private final ServiceRegistryImplementor serviceRegistry;
    private final String url;
    private final Properties connectionProps;
    private final boolean autoCommit;
    private final Integer isolation;

    public BasicConnectionCreator(ServiceRegistryImplementor serviceRegistry, String url, Properties connectionProps, boolean autocommit, Integer isolation) {
        this.serviceRegistry = serviceRegistry;
        this.url = url;
        this.connectionProps = connectionProps;
        this.autoCommit = autocommit;
        this.isolation = isolation;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Connection createConnection() {
        Connection conn = this.makeConnection(this.url, this.connectionProps);
        try {
            if (this.isolation != null) {
                conn.setTransactionIsolation(this.isolation);
            }
        }
        catch (SQLException e) {
            throw this.convertSqlException("Unable to set transaction isolation (" + this.isolation + ")", e);
        }
        try {
            if (conn.getAutoCommit() != this.autoCommit) {
                conn.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException e) {
            throw this.convertSqlException("Unable to set auto-commit (" + this.autoCommit + ")", e);
        }
        return conn;
    }

    protected JDBCException convertSqlException(String message, SQLException e) {
        return this.serviceRegistry.getService(JdbcServices.class).getSqlExceptionHelper().convert(e, message, null);
    }

    protected abstract Connection makeConnection(String var1, Properties var2);
}

