/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan.spi.AbstractCollectionReference;
import org.hibernate.loader.plan.spi.CopyContext;
import org.hibernate.loader.plan.spi.CopyableReturn;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.spi.ResultSetProcessingContext;

public class CollectionReturn
extends AbstractCollectionReference
implements Return,
CopyableReturn {
    private final String ownerEntityName;
    private final String ownerProperty;

    public CollectionReturn(SessionFactoryImplementor sessionFactory, LockMode lockMode, String ownerEntityName, String ownerProperty) {
        super(sessionFactory, lockMode, sessionFactory.getCollectionPersister(ownerEntityName + '.' + ownerProperty), new PropertyPath());
        this.ownerEntityName = ownerEntityName;
        this.ownerProperty = ownerProperty;
    }

    public CollectionReturn(CollectionReturn original, CopyContext copyContext) {
        super(original, copyContext);
        this.ownerEntityName = original.ownerEntityName;
        this.ownerProperty = original.ownerProperty;
    }

    public String getOwnerEntityName() {
        return this.ownerEntityName;
    }

    public String getOwnerProperty() {
        return this.ownerProperty;
    }

    @Override
    public void hydrate(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
    }

    @Override
    public void resolve(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
    }

    @Override
    public Object read(ResultSet resultSet, ResultSetProcessingContext context) throws SQLException {
        return null;
    }

    public String toString() {
        return "CollectionReturn(" + this.getCollectionPersister().getRole() + ")";
    }

    @Override
    public CollectionReturn makeCopy(CopyContext copyContext) {
        return new CollectionReturn(this, copyContext);
    }
}

