/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.internal.CollectionJoinableAssociationImpl;
import org.hibernate.loader.internal.EntityJoinableAssociationImpl;
import org.hibernate.loader.internal.EntityLoadQueryImpl;
import org.hibernate.loader.plan.spi.CollectionFetch;
import org.hibernate.loader.plan.spi.CollectionReference;
import org.hibernate.loader.plan.spi.CompositeFetch;
import org.hibernate.loader.plan.spi.EntityFetch;
import org.hibernate.loader.plan.spi.EntityReference;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.Return;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitationStrategyAdapter;
import org.hibernate.loader.plan.spi.visit.LoadPlanVisitor;
import org.hibernate.loader.spi.JoinableAssociation;
import org.hibernate.loader.spi.LoadQueryAliasResolutionContext;
import org.hibernate.loader.spi.LoadQueryBuilder;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.walking.spi.WalkingException;

public class EntityLoadQueryBuilderImpl
implements LoadQueryBuilder {
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LoadPlan loadPlan;
    private final List<JoinableAssociation> associations;

    public EntityLoadQueryBuilderImpl(LoadQueryInfluencers loadQueryInfluencers, LoadPlan loadPlan) {
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.loadPlan = loadPlan;
        LocalVisitationStrategy strategy = new LocalVisitationStrategy();
        LoadPlanVisitor.visit(loadPlan, strategy);
        this.associations = strategy.associations;
    }

    @Override
    public String generateSql(int batchSize, SessionFactoryImplementor sessionFactory, LoadQueryAliasResolutionContext aliasResolutionContext) {
        return this.generateSql(batchSize, this.getOuterJoinLoadable().getKeyColumnNames(), sessionFactory, aliasResolutionContext);
    }

    public String generateSql(int batchSize, String[] uniqueKey, SessionFactoryImplementor sessionFactory, LoadQueryAliasResolutionContext aliasResolutionContext) {
        EntityLoadQueryImpl loadQuery = new EntityLoadQueryImpl(this.getRootEntityReturn(), this.associations);
        return loadQuery.generateSql(uniqueKey, batchSize, this.getRootEntityReturn().getLockMode(), sessionFactory, aliasResolutionContext);
    }

    private EntityReturn getRootEntityReturn() {
        return (EntityReturn)this.loadPlan.getReturns().get(0);
    }

    private OuterJoinLoadable getOuterJoinLoadable() {
        return (OuterJoinLoadable)this.getRootEntityReturn().getEntityPersister();
    }

    private class LocalVisitationStrategy
    extends LoadPlanVisitationStrategyAdapter {
        private final List<JoinableAssociation> associations = new ArrayList<JoinableAssociation>();
        private Deque<EntityReference> entityReferenceStack = new ArrayDeque<EntityReference>();
        private Deque<CollectionReference> collectionReferenceStack = new ArrayDeque<CollectionReference>();
        private EntityReturn entityRootReturn;

        private LocalVisitationStrategy() {
        }

        @Override
        public void handleEntityReturn(EntityReturn rootEntityReturn) {
            this.entityRootReturn = rootEntityReturn;
        }

        @Override
        public void startingRootReturn(Return rootReturn) {
            if (!EntityReturn.class.isInstance(rootReturn)) {
                throw new WalkingException(String.format("Unexpected type of return; expected [%s]; instead it was [%s]", EntityReturn.class.getName(), rootReturn.getClass().getName()));
            }
            this.entityRootReturn = (EntityReturn)rootReturn;
            this.pushToStack(this.entityReferenceStack, this.entityRootReturn);
        }

        @Override
        public void finishingRootReturn(Return rootReturn) {
            if (!EntityReturn.class.isInstance(rootReturn)) {
                throw new WalkingException(String.format("Unexpected type of return; expected [%s]; instead it was [%s]", EntityReturn.class.getName(), rootReturn.getClass().getName()));
            }
            this.popFromStack(this.entityReferenceStack, this.entityRootReturn);
        }

        @Override
        public void startingEntityFetch(EntityFetch entityFetch) {
            EntityJoinableAssociationImpl assoc = new EntityJoinableAssociationImpl(entityFetch, this.getCurrentCollectionReference(), "", false, EntityLoadQueryBuilderImpl.this.loadQueryInfluencers.getEnabledFilters());
            this.associations.add(assoc);
            this.pushToStack(this.entityReferenceStack, entityFetch);
        }

        @Override
        public void finishingEntityFetch(EntityFetch entityFetch) {
            this.popFromStack(this.entityReferenceStack, entityFetch);
        }

        @Override
        public void startingCollectionFetch(CollectionFetch collectionFetch) {
            CollectionJoinableAssociationImpl assoc = new CollectionJoinableAssociationImpl(collectionFetch, this.getCurrentEntityReference(), "", false, EntityLoadQueryBuilderImpl.this.loadQueryInfluencers.getEnabledFilters());
            this.associations.add(assoc);
            this.pushToStack(this.collectionReferenceStack, collectionFetch);
        }

        @Override
        public void finishingCollectionFetch(CollectionFetch collectionFetch) {
            this.popFromStack(this.collectionReferenceStack, collectionFetch);
        }

        @Override
        public void startingCompositeFetch(CompositeFetch fetch) {
        }

        @Override
        public void finishingCompositeFetch(CompositeFetch fetch) {
        }

        @Override
        public void finish(LoadPlan loadPlan) {
            this.entityReferenceStack.clear();
            this.collectionReferenceStack.clear();
        }

        private EntityReference getCurrentEntityReference() {
            return this.entityReferenceStack.peekFirst() == null ? null : this.entityReferenceStack.peekFirst();
        }

        private CollectionReference getCurrentCollectionReference() {
            return this.collectionReferenceStack.peekFirst() == null ? null : this.collectionReferenceStack.peekFirst();
        }

        private <T> void pushToStack(Deque<T> stack, T value) {
            stack.push(value);
        }

        private <T> void popFromStack(Deque<T> stack, T expectedValue) {
            T poppedValue = stack.pop();
            if (poppedValue != expectedValue) {
                throw new WalkingException(String.format("Unexpected value from stack. Expected=[%s]; instead it was [%s].", expectedValue, poppedValue));
            }
        }
    }
}

