/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.service.spi.InjectService;

public class DialectFactoryImpl
implements DialectFactory {
    private StrategySelector strategySelector;
    private DialectResolver dialectResolver;

    @InjectService
    public void setStrategySelector(StrategySelector strategySelector) {
        this.strategySelector = strategySelector;
    }

    @InjectService
    public void setDialectResolver(DialectResolver dialectResolver) {
        this.dialectResolver = dialectResolver;
    }

    @Override
    public Dialect buildDialect(Map configValues, Connection connection) throws HibernateException {
        String dialectName = (String)configValues.get("hibernate.dialect");
        if (dialectName != null) {
            return this.constructDialect(dialectName);
        }
        return this.determineDialect(connection);
    }

    private Dialect constructDialect(String dialectName) {
        try {
            Dialect dialect = this.strategySelector.resolveStrategy(Dialect.class, dialectName);
            if (dialect == null) {
                throw new HibernateException("Unable to construct requested dialect [" + dialectName + "]");
            }
            return dialect;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to construct requested dialect [" + dialectName + "]", e);
        }
    }

    private Dialect determineDialect(Connection connection) {
        if (connection == null) {
            throw new HibernateException("Connection cannot be null when 'hibernate.dialect' not set");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Dialect dialect = this.dialectResolver.resolveDialect(databaseMetaData);
            if (dialect == null) {
                throw new HibernateException("Unable to determine Dialect to use [name=" + databaseMetaData.getDatabaseProductName() + ", majorVersion=" + databaseMetaData.getDatabaseMajorVersion() + "]; user must register resolver or explicitly set 'hibernate.dialect'");
            }
            return dialect;
        }
        catch (SQLException sqlException) {
            throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", sqlException);
        }
    }
}

