/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.result.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.JDBCException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.Loader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.result.NoMoreReturnsException;
import org.hibernate.result.Result;
import org.hibernate.result.Return;
import org.hibernate.result.spi.ResultContext;

public class ResultImpl
implements Result {
    private final ResultContext context;
    private final PreparedStatement jdbcStatement;
    private final CustomLoaderExtension loader;
    private CurrentReturnDescriptor currentReturnDescriptor;
    private boolean executed = false;

    public ResultImpl(ResultContext context, PreparedStatement jdbcStatement) {
        this.context = context;
        this.jdbcStatement = jdbcStatement;
        this.loader = ResultImpl.buildSpecializedCustomLoader(context);
    }

    @Override
    public boolean hasMoreReturns() {
        if (this.currentReturnDescriptor == null) {
            boolean isResultSet;
            if (this.executed) {
                try {
                    isResultSet = this.jdbcStatement.getMoreResults();
                }
                catch (SQLException e) {
                    throw this.convert(e, "Error calling CallableStatement.getMoreResults");
                }
            }
            try {
                isResultSet = this.jdbcStatement.execute();
            }
            catch (SQLException e) {
                throw this.convert(e, "Error calling CallableStatement.execute");
            }
            this.executed = true;
            int updateCount = -1;
            if (!isResultSet) {
                try {
                    updateCount = this.jdbcStatement.getUpdateCount();
                }
                catch (SQLException e) {
                    throw this.convert(e, "Error calling CallableStatement.getUpdateCount");
                }
            }
            this.currentReturnDescriptor = this.buildCurrentReturnDescriptor(isResultSet, updateCount);
        }
        return this.hasMoreReturns(this.currentReturnDescriptor);
    }

    protected CurrentReturnDescriptor buildCurrentReturnDescriptor(boolean isResultSet, int updateCount) {
        return new CurrentReturnDescriptor(isResultSet, updateCount);
    }

    protected boolean hasMoreReturns(CurrentReturnDescriptor descriptor) {
        return descriptor.isResultSet || descriptor.updateCount >= 0;
    }

    @Override
    public Return getNextReturn() {
        if (this.currentReturnDescriptor == null) {
            if (this.executed) {
                throw new IllegalStateException("Unexpected condition");
            }
            throw new IllegalStateException("hasMoreReturns() not called before getNextReturn()");
        }
        if (!this.hasMoreReturns(this.currentReturnDescriptor)) {
            throw new NoMoreReturnsException("Results have been exhausted");
        }
        CurrentReturnDescriptor copyReturnDescriptor = this.currentReturnDescriptor;
        this.currentReturnDescriptor = null;
        if (copyReturnDescriptor.isResultSet) {
            try {
                return new ResultSetReturn(this, this.jdbcStatement.getResultSet());
            }
            catch (SQLException e) {
                throw this.convert(e, "Error calling CallableStatement.getResultSet");
            }
        }
        if (copyReturnDescriptor.updateCount >= 0) {
            return new UpdateCountReturn(this, copyReturnDescriptor.updateCount);
        }
        return this.buildExtendedReturn(copyReturnDescriptor);
    }

    protected Return buildExtendedReturn(CurrentReturnDescriptor copyReturnDescriptor) {
        throw new NoMoreReturnsException("Results have been exhausted");
    }

    protected JDBCException convert(SQLException e, String message) {
        return this.context.getSession().getFactory().getSQLExceptionHelper().convert(e, message, this.context.getSql());
    }

    private static CustomLoaderExtension buildSpecializedCustomLoader(final ResultContext context) {
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(context.getQueryReturns(), context.getSession().getFactory());
        processor.process();
        final List<org.hibernate.loader.custom.Return> customReturns = processor.generateCustomReturns(false);
        CustomQuery customQuery = new CustomQuery(){

            @Override
            public String getSQL() {
                return context.getSql();
            }

            @Override
            public Set<String> getQuerySpaces() {
                return context.getSynchronizedQuerySpaces();
            }

            @Override
            public Map getNamedParameterBindPoints() {
                return null;
            }

            @Override
            public List<org.hibernate.loader.custom.Return> getCustomQueryReturns() {
                return customReturns;
            }
        };
        return new CustomLoaderExtension(customQuery, context.getQueryParameters(), context.getSession());
    }

    private static class CustomLoaderExtension
    extends CustomLoader {
        private QueryParameters queryParameters;
        private SessionImplementor session;

        public CustomLoaderExtension(CustomQuery customQuery, QueryParameters queryParameters, SessionImplementor session) {
            super(customQuery, session.getFactory());
            this.queryParameters = queryParameters;
            this.session = session;
        }

        public List processResultSet(ResultSet resultSet) throws SQLException {
            super.autoDiscoverTypes(resultSet);
            return super.processResultSet(resultSet, this.queryParameters, this.session, true, null, Integer.MAX_VALUE, Collections.<Loader.AfterLoadAction>emptyList());
        }
    }

    protected static class UpdateCountReturn
    implements org.hibernate.result.UpdateCountReturn {
        private final ResultImpl result;
        private final int updateCount;

        public UpdateCountReturn(ResultImpl result, int updateCount) {
            this.result = result;
            this.updateCount = updateCount;
        }

        @Override
        public int getUpdateCount() {
            return this.updateCount;
        }

        @Override
        public boolean isResultSet() {
            return false;
        }
    }

    protected static class ResultSetReturn
    implements org.hibernate.result.ResultSetReturn {
        private final ResultImpl storedProcedureOutputs;
        private final ResultSet resultSet;

        public ResultSetReturn(ResultImpl storedProcedureOutputs, ResultSet resultSet) {
            this.storedProcedureOutputs = storedProcedureOutputs;
            this.resultSet = resultSet;
        }

        @Override
        public boolean isResultSet() {
            return true;
        }

        @Override
        public List getResultList() {
            try {
                return this.storedProcedureOutputs.loader.processResultSet(this.resultSet);
            }
            catch (SQLException e) {
                throw this.storedProcedureOutputs.convert(e, "Error calling ResultSet.next");
            }
        }

        @Override
        public Object getSingleResult() {
            List results = this.getResultList();
            if (results == null || results.isEmpty()) {
                return null;
            }
            return results.get(0);
        }
    }

    protected static class CurrentReturnDescriptor {
        private final boolean isResultSet;
        private final int updateCount;

        protected CurrentReturnDescriptor(boolean isResultSet, int updateCount) {
            this.isResultSet = isResultSet;
            this.updateCount = updateCount;
        }
    }
}

