/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.ParameterMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractBasicQueryContractImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.NamedParametersNotSupportedException;
import org.hibernate.procedure.ParameterRegistration;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureResult;
import org.hibernate.procedure.internal.NamedParameterRegistration;
import org.hibernate.procedure.internal.ParameterRegistrationImplementor;
import org.hibernate.procedure.internal.ParameterStrategy;
import org.hibernate.procedure.internal.PositionalParameterRegistration;
import org.hibernate.procedure.internal.ProcedureResultImpl;
import org.hibernate.result.spi.ResultContext;
import org.hibernate.type.Type;

public class ProcedureCallImpl
extends AbstractBasicQueryContractImpl
implements ProcedureCall,
ResultContext {
    private final String procedureName;
    private final NativeSQLQueryReturn[] queryReturns;
    private ParameterStrategy parameterStrategy = ParameterStrategy.UNKNOWN;
    private List<ParameterRegistrationImplementor<?>> registeredParameters = new ArrayList();
    private Set<String> synchronizedQuerySpaces;
    private ProcedureResultImpl outputs;

    public ProcedureCallImpl(SessionImplementor session, String procedureName) {
        this(session, procedureName, (List<NativeSQLQueryReturn>)null);
    }

    public ProcedureCallImpl(SessionImplementor session, String procedureName, List<NativeSQLQueryReturn> queryReturns) {
        super(session);
        this.procedureName = procedureName;
        this.queryReturns = queryReturns == null || queryReturns.isEmpty() ? new NativeSQLQueryReturn[0] : queryReturns.toArray(new NativeSQLQueryReturn[queryReturns.size()]);
    }

    public ProcedureCallImpl(SessionImplementor session, String procedureName, Class ... resultClasses) {
        this(session, procedureName, ProcedureCallImpl.collectQueryReturns(resultClasses));
    }

    private static List<NativeSQLQueryReturn> collectQueryReturns(Class[] resultClasses) {
        if (resultClasses == null || resultClasses.length == 0) {
            return null;
        }
        ArrayList<NativeSQLQueryReturn> queryReturns = new ArrayList<NativeSQLQueryReturn>(resultClasses.length);
        int i = 1;
        for (Class resultClass : resultClasses) {
            queryReturns.add(new NativeSQLQueryRootReturn("alias" + i, resultClass.getName(), LockMode.READ));
            ++i;
        }
        return queryReturns;
    }

    public ProcedureCallImpl(SessionImplementor session, String procedureName, String ... resultSetMappings) {
        this(session, procedureName, ProcedureCallImpl.collectQueryReturns(session, resultSetMappings));
    }

    private static List<NativeSQLQueryReturn> collectQueryReturns(SessionImplementor session, String[] resultSetMappings) {
        if (resultSetMappings == null || resultSetMappings.length == 0) {
            return null;
        }
        ArrayList<NativeSQLQueryReturn> queryReturns = new ArrayList<NativeSQLQueryReturn>(resultSetMappings.length);
        for (String resultSetMapping : resultSetMappings) {
            ResultSetMappingDefinition mapping = session.getFactory().getResultSetMapping(resultSetMapping);
            if (mapping == null) {
                throw new MappingException("Unknown SqlResultSetMapping [" + resultSetMapping + "]");
            }
            queryReturns.addAll(Arrays.asList(mapping.getQueryReturns()));
        }
        return queryReturns;
    }

    @Override
    public SessionImplementor getSession() {
        return super.session();
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public String getSql() {
        return this.getProcedureName();
    }

    @Override
    public NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns;
    }

    @Override
    public <T> ParameterRegistration<T> registerParameter(int position, Class<T> type, ParameterMode mode) {
        PositionalParameterRegistration<T> parameterRegistration = new PositionalParameterRegistration<T>(this, position, type, mode);
        this.registerParameter(parameterRegistration);
        return parameterRegistration;
    }

    @Override
    public ProcedureCall registerParameter0(int position, Class type, ParameterMode mode) {
        this.registerParameter(position, type, mode);
        return this;
    }

    private void registerParameter(ParameterRegistrationImplementor parameter) {
        if (StringHelper.isNotEmpty(parameter.getName())) {
            this.prepareForNamedParameters();
        } else if (parameter.getPosition() != null) {
            this.prepareForPositionalParameters();
        } else {
            throw new IllegalArgumentException("Given parameter did not define name or position [" + parameter + "]");
        }
        this.registeredParameters.add(parameter);
    }

    private void prepareForPositionalParameters() {
        if (this.parameterStrategy == ParameterStrategy.NAMED) {
            throw new QueryException("Cannot mix named and positional parameters");
        }
        this.parameterStrategy = ParameterStrategy.POSITIONAL;
    }

    private void prepareForNamedParameters() {
        if (this.parameterStrategy == ParameterStrategy.POSITIONAL) {
            throw new QueryException("Cannot mix named and positional parameters");
        }
        if (this.parameterStrategy == null) {
            ExtractedDatabaseMetaData databaseMetaData = this.getSession().getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getJdbcServices().getExtractedMetaDataSupport();
            if (!databaseMetaData.supportsNamedParameters()) {
                throw new NamedParametersNotSupportedException("Named stored procedure parameters used, but JDBC driver does not support named parameters");
            }
            this.parameterStrategy = ParameterStrategy.NAMED;
        }
    }

    @Override
    public ParameterRegistrationImplementor getParameterRegistration(int position) {
        if (this.parameterStrategy != ParameterStrategy.POSITIONAL) {
            throw new IllegalArgumentException("Positions were not used to register parameters with this stored procedure call");
        }
        try {
            return this.registeredParameters.get(position);
        }
        catch (Exception e) {
            throw new QueryException("Could not locate parameter registered using that position [" + position + "]");
        }
    }

    @Override
    public <T> ParameterRegistration<T> registerParameter(String name, Class<T> type, ParameterMode mode) {
        NamedParameterRegistration<T> parameterRegistration = new NamedParameterRegistration<T>(this, name, type, mode);
        this.registerParameter(parameterRegistration);
        return parameterRegistration;
    }

    @Override
    public ProcedureCall registerParameter0(String name, Class type, ParameterMode mode) {
        this.registerParameter(name, type, mode);
        return this;
    }

    @Override
    public ParameterRegistrationImplementor getParameterRegistration(String name) {
        if (this.parameterStrategy != ParameterStrategy.NAMED) {
            throw new IllegalArgumentException("Names were not used to register parameters with this stored procedure call");
        }
        for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new IllegalArgumentException("Could not locate parameter registered under that name [" + name + "]");
    }

    @Override
    public List<ParameterRegistration> getRegisteredParameters() {
        return new ArrayList<ParameterRegistration>(this.registeredParameters);
    }

    @Override
    public ProcedureResult getResult() {
        if (this.outputs == null) {
            this.outputs = this.buildOutputs();
        }
        return this.outputs;
    }

    private ProcedureResultImpl buildOutputs() {
        StringBuilder buffer = new StringBuilder().append("{call ").append(this.procedureName).append("(");
        String sep = "";
        for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
            for (int i = 0; i < parameter.getSqlTypes().length; ++i) {
                buffer.append(sep).append("?");
                sep = ",";
            }
        }
        buffer.append(")}");
        try {
            CallableStatement statement = (CallableStatement)this.getSession().getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(buffer.toString(), true);
            int i = 1;
            for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
                if (parameter == null) {
                    throw new QueryException("Registered stored procedure parameters had gaps");
                }
                parameter.prepare(statement, i);
                i += parameter.getSqlTypes().length;
            }
            return new ProcedureResultImpl(this, statement);
        }
        catch (SQLException e) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(e, "Error preparing CallableStatement", this.getProcedureName());
        }
    }

    @Override
    public Type[] getReturnTypes() throws HibernateException {
        throw new NotYetImplementedException();
    }

    protected Set<String> synchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            this.synchronizedQuerySpaces = new HashSet<String>();
        }
        return this.synchronizedQuerySpaces;
    }

    @Override
    public Set<String> getSynchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.synchronizedQuerySpaces);
    }

    @Override
    public ProcedureCallImpl addSynchronizedQuerySpace(String querySpace) {
        this.synchronizedQuerySpaces().add(querySpace);
        return this;
    }

    @Override
    public ProcedureCallImpl addSynchronizedEntityName(String entityName) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getEntityPersister(entityName));
        return this;
    }

    protected void addSynchronizedQuerySpaces(EntityPersister persister) {
        this.synchronizedQuerySpaces().addAll(Arrays.asList((String[])persister.getQuerySpaces()));
    }

    @Override
    public ProcedureCallImpl addSynchronizedEntityClass(Class entityClass) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getEntityPersister(entityClass.getName()));
        return this;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.buildQueryParametersObject();
    }

    @Override
    public QueryParameters buildQueryParametersObject() {
        QueryParameters qp = super.buildQueryParametersObject();
        qp.setAutoDiscoverScalarTypes(true);
        qp.setCallable(true);
        return qp;
    }

    public ParameterRegistrationImplementor[] collectRefCursorParameters() {
        ArrayList refCursorParams = new ArrayList();
        for (ParameterRegistrationImplementor<?> param : this.registeredParameters) {
            if (param.getMode() != ParameterMode.REF_CURSOR) continue;
            refCursorParams.add(param);
        }
        return refCursorParams.toArray(new ParameterRegistrationImplementor[refCursorParams.size()]);
    }
}

