/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.spi;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.BasicSQLExceptionConverter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public abstract class AbstractDatabaseMetaDataDialectResolver
implements DialectResolver {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)AbstractDatabaseMetaDataDialectResolver.class.getName());

    @Override
    public final Dialect resolveDialect(DatabaseMetaData metaData) {
        try {
            return this.resolveDialectInternal(metaData);
        }
        catch (SQLException sqlException) {
            JDBCException jdbcException = BasicSQLExceptionConverter.INSTANCE.convert(sqlException);
            if (jdbcException instanceof JDBCConnectionException) {
                throw jdbcException;
            }
            LOG.warnf("%s : %s", BasicSQLExceptionConverter.MSG, sqlException.getMessage());
            return null;
        }
        catch (Throwable t) {
            LOG.unableToExecuteResolver(this, t.getMessage());
            return null;
        }
    }

    protected abstract Dialect resolveDialectInternal(DatabaseMetaData var1) throws SQLException;
}

