/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;

public class CUBRIDLimitHandler
extends AbstractLimitHandler {
    private final Dialect dialect;

    public CUBRIDLimitHandler(Dialect dialect, String sql, RowSelection selection) {
        super(sql, selection);
        this.dialect = dialect;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getProcessedSql() {
        if (LimitHelper.useLimit(this, this.selection)) {
            boolean useLimitOffset = LimitHelper.hasFirstRow(this.selection);
            return new StringBuilder(this.sql.length() + 20).append(this.sql).append(useLimitOffset ? " limit ?, ?" : " limit ?").toString();
        }
        return this.sql;
    }
}

