/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import javax.persistence.AttributeConverter;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.jboss.logging.Logger;

public class AttributeConverterDefinition {
    private static final Logger log = Logger.getLogger(AttributeConverterDefinition.class);
    private final AttributeConverter attributeConverter;
    private final boolean autoApply;
    private final Class entityAttributeType;
    private final Class databaseColumnType;

    public AttributeConverterDefinition(AttributeConverter attributeConverter, boolean autoApply) {
        this.attributeConverter = attributeConverter;
        this.autoApply = autoApply;
        Class<?> attributeConverterClass = attributeConverter.getClass();
        ParameterizedType attributeConverterSignature = this.extractAttributeConverterParameterizedType(attributeConverterClass);
        if (attributeConverterSignature.getActualTypeArguments().length < 2) {
            throw new AnnotationException("AttributeConverter [" + attributeConverterClass.getName() + "] did not retain parameterized type information");
        }
        if (attributeConverterSignature.getActualTypeArguments().length > 2) {
            throw new AnnotationException("AttributeConverter [" + attributeConverterClass.getName() + "] specified more than 2 parameterized types");
        }
        this.entityAttributeType = (Class)attributeConverterSignature.getActualTypeArguments()[0];
        if (this.entityAttributeType == null) {
            throw new AnnotationException("Could not determine 'entity attribute' type from given AttributeConverter [" + attributeConverterClass.getName() + "]");
        }
        this.databaseColumnType = (Class)attributeConverterSignature.getActualTypeArguments()[1];
        if (this.databaseColumnType == null) {
            throw new AnnotationException("Could not determine 'database column' type from given AttributeConverter [" + attributeConverterClass.getName() + "]");
        }
    }

    private ParameterizedType extractAttributeConverterParameterizedType(Class attributeConverterClass) {
        for (Type type : attributeConverterClass.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!ParameterizedType.class.isInstance(type) || !AttributeConverter.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
            return parameterizedType;
        }
        throw new AssertionFailure("Could not extract ParameterizedType representation of AttributeConverter definition from AttributeConverter implementation class [" + attributeConverterClass.getName() + "]");
    }

    public AttributeConverter getAttributeConverter() {
        return this.attributeConverter;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public Class getEntityAttributeType() {
        return this.entityAttributeType;
    }

    public Class getDatabaseColumnType() {
        return this.databaseColumnType;
    }

    private static Class extractType(TypeVariable typeVariable) {
        Type[] boundTypes = typeVariable.getBounds();
        if (boundTypes == null || boundTypes.length != 1) {
            return null;
        }
        return (Class)boundTypes[0];
    }
}

