/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class RegionFactoryInitiator
implements StandardServiceInitiator<RegionFactory> {
    public static final RegionFactoryInitiator INSTANCE = new RegionFactoryInitiator();
    public static final String IMPL_NAME = "hibernate.cache.region.factory_class";

    @Override
    public Class<RegionFactory> getServiceInitiated() {
        return RegionFactory.class;
    }

    @Override
    public RegionFactory initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Object setting = configurationValues.get(IMPL_NAME);
        return registry.getService(StrategySelector.class).resolveDefaultableStrategy(RegionFactory.class, setting, NoCachingRegionFactory.INSTANCE);
    }

    public static String mapLegacyNames(String name) {
        if ("org.hibernate.cache.EhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.EhCacheRegionFactory";
        }
        if ("org.hibernate.cache.SingletonEhCacheRegionFactory".equals(name)) {
            return "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory";
        }
        return name;
    }
}

