/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.selector.Availability;
import org.hibernate.boot.registry.selector.AvailabilityAnnouncer;
import org.hibernate.boot.registry.selector.internal.StrategySelectorBuilder;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;

public class BootstrapServiceRegistryBuilder {
    private final LinkedHashSet<Integrator> providedIntegrators = new LinkedHashSet();
    private List<ClassLoader> providedClassLoaders;
    private ClassLoaderService providedClassLoaderService;
    private StrategySelectorBuilder strategySelectorBuilder = new StrategySelectorBuilder();

    public BootstrapServiceRegistryBuilder with(Integrator integrator) {
        this.providedIntegrators.add(integrator);
        return this;
    }

    public BootstrapServiceRegistryBuilder with(ClassLoader classLoader) {
        if (this.providedClassLoaders == null) {
            this.providedClassLoaders = new ArrayList<ClassLoader>();
        }
        this.providedClassLoaders.add(classLoader);
        return this;
    }

    public BootstrapServiceRegistryBuilder with(ClassLoaderService classLoaderService) {
        this.providedClassLoaderService = classLoaderService;
        return this;
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withApplicationClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withResourceClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withHibernateClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    @Deprecated
    public BootstrapServiceRegistryBuilder withEnvironmentClassLoader(ClassLoader classLoader) {
        return this.with(classLoader);
    }

    public <T> BootstrapServiceRegistryBuilder withStrategySelector(Class<T> strategy, String name, Class<? extends T> implementation) {
        this.strategySelectorBuilder.addExplicitAvailability(strategy, implementation, name);
        return this;
    }

    public <T> BootstrapServiceRegistryBuilder withStrategySelectors(AvailabilityAnnouncer availabilityAnnouncer) {
        for (Availability availability : availabilityAnnouncer.getAvailabilities()) {
            this.strategySelectorBuilder.addExplicitAvailability(availability);
        }
        return this;
    }

    public BootstrapServiceRegistry build() {
        ClassLoaderService classLoaderService;
        if (this.providedClassLoaderService == null) {
            HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
            if (this.providedClassLoaders != null) {
                classLoaders.addAll(this.providedClassLoaders);
            }
            classLoaderService = new ClassLoaderServiceImpl(classLoaders);
        } else {
            classLoaderService = this.providedClassLoaderService;
        }
        IntegratorServiceImpl integratorService = new IntegratorServiceImpl(this.providedIntegrators, classLoaderService);
        return new BootstrapServiceRegistryImpl(classLoaderService, this.strategySelectorBuilder.buildSelector(classLoaderService), integratorService);
    }
}

