/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.hibernate.MappingException;

public enum FlushMode {
    NEVER(0),
    MANUAL(0),
    COMMIT(5),
    AUTO(10),
    ALWAYS(20);

    private final int level;

    private FlushMode(int level) {
        this.level = level;
    }

    public boolean lessThan(FlushMode other) {
        return this.level < other.level;
    }

    public static boolean isManualFlushMode(FlushMode mode) {
        return FlushMode.MANUAL.level == mode.level;
    }

    public static FlushMode interpretExternalSetting(String setting) {
        if (setting == null) {
            return null;
        }
        try {
            return FlushMode.valueOf(setting.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MappingException("unknown FlushMode : " + setting);
        }
    }
}

