/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.QueryTimeoutException;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.type.StandardBasicTypes;

public class SQLServer2005Dialect
extends SQLServerDialect {
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String DISTINCT = "distinct";
    private static final String ORDER_BY = "order by";
    private static final int MAX_LENGTH = 8000;
    private static final Pattern ALIAS_PATTERN = Pattern.compile("\\sas\\s[^,]+(,?)");
    public static final String SELECT_WITH_SPACE = "select ";

    public SQLServer2005Dialect() {
        this.registerColumnType(2004, "varbinary(MAX)");
        this.registerColumnType(-3, "varbinary(MAX)");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        this.registerColumnType(-4, "varbinary(MAX)");
        this.registerColumnType(2005, "varchar(MAX)");
        this.registerColumnType(-1, "varchar(MAX)");
        this.registerColumnType(12, "varchar(MAX)");
        this.registerColumnType(12, 8000L, "varchar($l)");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerFunction("row_number", new NoArgSQLFunction("row_number", StandardBasicTypes.INTEGER, true));
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1;
    }

    @Override
    public String getLimitString(String query, int offset, int limit) {
        if (offset > 1 || limit > 1) {
            return this.getLimitString(query, true);
        }
        return query;
    }

    @Override
    public String getLimitString(String querySqlString, boolean hasOffset) {
        String orderby;
        StringBuilder sb = new StringBuilder(querySqlString.trim());
        int orderByIndex = SQLServer2005Dialect.shallowIndexOfWord(sb, ORDER_BY, 0);
        CharSequence charSequence = orderby = orderByIndex > 0 ? sb.subSequence(orderByIndex, sb.length()) : "ORDER BY CURRENT_TIMESTAMP";
        if (orderByIndex > 0) {
            sb.delete(orderByIndex, orderByIndex + orderby.length());
        }
        SQLServer2005Dialect.replaceDistinctWithGroupBy(sb);
        this.insertRowNumberFunction(sb, orderby);
        sb.insert(0, "WITH query AS (").append(") SELECT * FROM query ");
        sb.append("WHERE __hibernate_row_nr__ >= ? AND __hibernate_row_nr__ < ?");
        return sb.toString();
    }

    protected static void replaceDistinctWithGroupBy(StringBuilder sql) {
        int distinctIndex = SQLServer2005Dialect.shallowIndexOfWord(sql, DISTINCT, 0);
        int selectEndIndex = SQLServer2005Dialect.shallowIndexOfWord(sql, FROM, 0);
        if (distinctIndex > 0 && distinctIndex < selectEndIndex) {
            sql.delete(distinctIndex, distinctIndex + DISTINCT.length() + " ".length());
            sql.append(" group by").append(SQLServer2005Dialect.getSelectFieldsWithoutAliases(sql));
        }
    }

    protected static CharSequence getSelectFieldsWithoutAliases(StringBuilder sql) {
        int selectStartPos = SQLServer2005Dialect.shallowIndexOf(sql, SELECT_WITH_SPACE, 0);
        int fromStartPos = SQLServer2005Dialect.shallowIndexOfWord(sql, FROM, selectStartPos);
        String select = sql.substring(selectStartPos + SELECT.length(), fromStartPos);
        return SQLServer2005Dialect.stripAliases(select);
    }

    protected static String stripAliases(String str) {
        Matcher matcher = ALIAS_PATTERN.matcher(str);
        return matcher.replaceAll("$1");
    }

    protected void insertRowNumberFunction(StringBuilder sql, CharSequence orderby) {
        int selectEndIndex = SQLServer2005Dialect.shallowIndexOfWord(sql, FROM, 0);
        sql.insert(selectEndIndex - 1, ", ROW_NUMBER() OVER (" + orderby + ") as __hibernate_row_nr__");
    }

    @Override
    public String appendLockHint(LockMode mode, String tableName) {
        if (mode == LockMode.UPGRADE_NOWAIT) {
            return tableName + " with (updlock, rowlock, nowait)";
        }
        return super.appendLockHint(mode, tableName);
    }

    private static int shallowIndexOfWord(StringBuilder sb, String search, int fromIndex) {
        int index = SQLServer2005Dialect.shallowIndexOf(sb, ' ' + search + ' ', fromIndex);
        return index != -1 ? index + 1 : -1;
    }

    private static int shallowIndexOf(StringBuilder sb, String search, int fromIndex) {
        String lowercase = sb.toString().toLowerCase();
        int len = lowercase.length();
        int searchlen = search.length();
        int pos = -1;
        int depth = 0;
        int cur = fromIndex;
        do {
            if ((pos = lowercase.indexOf(search, cur)) == -1) continue;
            for (int iter = cur; iter < pos; ++iter) {
                char c = sb.charAt(iter);
                if (c == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                --depth;
            }
            cur = pos + searchlen;
        } while (cur < len && depth != 0 && pos != -1);
        return depth == 0 ? pos : -1;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            @Override
            public JDBCException convert(SQLException sqlException, String message, String sql) {
                String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
                if ("HY008".equals(sqlState)) {
                    throw new QueryTimeoutException(message, sqlException, sql);
                }
                return null;
            }
        };
    }
}

