/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class NaturalIdCacheKey
implements Serializable {
    private final Serializable[] naturalIdValues;
    private final String entityName;
    private final String tenantId;
    private final int hashCode;
    private final String toString;

    public NaturalIdCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        this.entityName = persister.getRootEntityName();
        this.tenantId = session.getTenantIdentifier();
        Serializable[] disassembledNaturalId = new Serializable[naturalIdValues.length];
        StringBuilder toStringBuilder = new StringBuilder(this.entityName).append("##NaturalId[");
        SessionFactoryImplementor factory = session.getFactory();
        int[] naturalIdPropertyIndexes = persister.getNaturalIdentifierProperties();
        Type[] propertyTypes = persister.getPropertyTypes();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityName == null ? 0 : this.entityName.hashCode());
        result = 31 * result + (this.tenantId == null ? 0 : this.tenantId.hashCode());
        for (int i = 0; i < naturalIdValues.length; ++i) {
            Type type = propertyTypes[naturalIdPropertyIndexes[i]];
            Object value = naturalIdValues[i];
            result = 31 * result + (value != null ? type.getHashCode(value, factory) : 0);
            disassembledNaturalId[i] = type.disassemble(value, session, null);
            toStringBuilder.append(type.toLoggableString(value, factory));
            if (i + 1 >= naturalIdValues.length) continue;
            toStringBuilder.append(", ");
        }
        toStringBuilder.append("]");
        this.naturalIdValues = disassembledNaturalId;
        this.hashCode = result;
        this.toString = toStringBuilder.toString();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Serializable[] getNaturalIdValues() {
        return this.naturalIdValues;
    }

    public String toString() {
        return this.toString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NaturalIdCacheKey other = (NaturalIdCacheKey)o;
        return this.entityName.equals(other.entityName) && EqualsHelper.equals(this.tenantId, other.tenantId) && Arrays.equals(this.naturalIdValues, other.naturalIdValues);
    }
}

