/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import org.hibernate.stat.CategorizedStatistics;
import org.hibernate.stat.QueryStatistics;

public class QueryStatisticsImpl
extends CategorizedStatistics
implements QueryStatistics {
    long cacheHitCount;
    long cacheMissCount;
    long cachePutCount;
    private long executionCount;
    private long executionRowCount;
    private long executionAvgTime;
    private long executionMaxTime;
    private long executionMinTime = Long.MAX_VALUE;

    QueryStatisticsImpl(String query) {
        super(query);
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public long getCacheHitCount() {
        return this.cacheHitCount;
    }

    public long getCachePutCount() {
        return this.cachePutCount;
    }

    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    public long getExecutionRowCount() {
        return this.executionRowCount;
    }

    public long getExecutionAvgTime() {
        return this.executionAvgTime;
    }

    public long getExecutionMaxTime() {
        return this.executionMaxTime;
    }

    public long getExecutionMinTime() {
        return this.executionMinTime;
    }

    void executed(long rows, long time) {
        if (time < this.executionMinTime) {
            this.executionMinTime = time;
        }
        if (time > this.executionMaxTime) {
            this.executionMaxTime = time;
        }
        this.executionAvgTime = (this.executionAvgTime * this.executionCount + time) / (this.executionCount + 1L);
        ++this.executionCount;
        this.executionRowCount += rows;
    }

    public String toString() {
        return new StringBuilder().append("QueryStatistics").append("[cacheHitCount=").append(this.cacheHitCount).append(",cacheMissCount=").append(this.cacheMissCount).append(",cachePutCount=").append(this.cachePutCount).append(",executionCount=").append(this.executionCount).append(",executionRowCount=").append(this.executionRowCount).append(",executionAvgTime=").append(this.executionAvgTime).append(",executionMaxTime=").append(this.executionMaxTime).append(",executionMinTime=").append(this.executionMinTime).append(']').toString();
    }
}

