/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleHiLoPerTableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger((Class)MultipleHiLoPerTableGenerator.class);
    public static final String ID_TABLE = "table";
    public static final String PK_COLUMN_NAME = "primary_key_column";
    public static final String PK_VALUE_NAME = "primary_key_value";
    public static final String VALUE_COLUMN_NAME = "value_column";
    public static final String PK_LENGTH_NAME = "primary_key_length";
    private static final int DEFAULT_PK_LENGTH = 255;
    public static final String DEFAULT_TABLE = "hibernate_sequences";
    private static final String DEFAULT_PK_COLUMN = "sequence_name";
    private static final String DEFAULT_VALUE_COLUMN = "sequence_next_hi_value";
    private String tableName;
    private String pkColumnName;
    private String valueColumnName;
    private String query;
    private String insert;
    private String update;
    public static final String MAX_LO = "max_lo";
    private int maxLo;
    private int lo;
    private IntegralDataTypeHolder value;
    private Class returnClass;
    private int keySize;

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + ' ' + this.tableName + " ( " + this.pkColumnName + ' ' + dialect.getTypeName(12, this.keySize, 0, 0) + ",  " + this.valueColumnName + ' ' + dialect.getTypeName(4) + " ) "};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    public Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        int rows;
        IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass);
        do {
            SQL_STATEMENT_LOGGER.logStatement(sql, FormatStyle.BASIC);
            PreparedStatement qps = conn.prepareStatement(this.query);
            Statement ips = null;
            try {
                ResultSet rs = qps.executeQuery();
                boolean isInitialized = rs.next();
                if (!isInitialized) {
                    value.initialize(0L);
                    ips = conn.prepareStatement(this.insert);
                    value.bind((PreparedStatement)ips, 1);
                    ips.execute();
                } else {
                    value.initialize(rs, 0L);
                }
                rs.close();
            }
            catch (SQLException sqle) {
                log.error("could not read or init a hi value", (Throwable)sqle);
                throw sqle;
            }
            finally {
                if (ips != null) {
                    ips.close();
                }
                qps.close();
            }
            PreparedStatement ups = conn.prepareStatement(this.update);
            try {
                value.copy().increment().bind(ups, 1);
                value.bind(ups, 2);
                rows = ups.executeUpdate();
            }
            catch (SQLException sqle) {
                log.error("could not update hi value in: " + this.tableName, (Throwable)sqle);
                throw sqle;
            }
            finally {
                ups.close();
            }
        } while (rows == 0);
        return value;
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        if (this.maxLo < 1) {
            IntegralDataTypeHolder value = null;
            while (value == null || value.lt(1L)) {
                value = (IntegralDataTypeHolder)this.doWorkInNewTransaction(session);
            }
            return value.makeValue();
        }
        if (this.lo > this.maxLo) {
            IntegralDataTypeHolder hiVal = (IntegralDataTypeHolder)this.doWorkInNewTransaction(session);
            this.lo = hiVal.eq(0L) ? 1 : 0;
            this.value = hiVal.copy().multiplyBy(this.maxLo + 1).add(this.lo);
            if (log.isDebugEnabled()) {
                log.debug("new hi value: " + hiVal);
            }
        }
        return this.value.makeValueThenIncrement();
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        this.tableName = normalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(ID_TABLE, params, DEFAULT_TABLE));
        if (this.tableName.indexOf(46) < 0) {
            this.tableName = dialect.quote(this.tableName);
            String schemaName = dialect.quote(normalizer.normalizeIdentifierQuoting(params.getProperty("schema")));
            String catalogName = dialect.quote(normalizer.normalizeIdentifierQuoting(params.getProperty("catalog")));
            this.tableName = Table.qualify(catalogName, schemaName, this.tableName);
        }
        this.pkColumnName = dialect.quote(normalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(PK_COLUMN_NAME, params, DEFAULT_PK_COLUMN)));
        this.valueColumnName = dialect.quote(normalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(VALUE_COLUMN_NAME, params, DEFAULT_VALUE_COLUMN)));
        this.keySize = PropertiesHelper.getInt(PK_LENGTH_NAME, params, 255);
        String keyValue = PropertiesHelper.getString(PK_VALUE_NAME, params, params.getProperty("target_table"));
        this.query = "select " + this.valueColumnName + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableName) + " where " + this.pkColumnName + " = '" + keyValue + "'" + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.valueColumnName + " = ? where " + this.valueColumnName + " = ? and " + this.pkColumnName + " = '" + keyValue + "'";
        this.insert = "insert into " + this.tableName + "(" + this.pkColumnName + ", " + this.valueColumnName + ") " + "values('" + keyValue + "', ?)";
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }
}

