/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.SingletonIterator;

public class Subclass
extends PersistentClass {
    private PersistentClass superclass;
    private Class classPersisterClass;
    private final int subclassId;

    public Subclass(PersistentClass superclass) {
        this.superclass = superclass;
        this.subclassId = superclass.nextSubclassId();
    }

    int nextSubclassId() {
        return this.getSuperclass().nextSubclassId();
    }

    public int getSubclassId() {
        return this.subclassId;
    }

    public String getCacheConcurrencyStrategy() {
        return this.getSuperclass().getCacheConcurrencyStrategy();
    }

    public RootClass getRootClass() {
        return this.getSuperclass().getRootClass();
    }

    public PersistentClass getSuperclass() {
        return this.superclass;
    }

    public Property getIdentifierProperty() {
        return this.getSuperclass().getIdentifierProperty();
    }

    public Property getDeclaredIdentifierProperty() {
        return null;
    }

    public KeyValue getIdentifier() {
        return this.getSuperclass().getIdentifier();
    }

    public boolean hasIdentifierProperty() {
        return this.getSuperclass().hasIdentifierProperty();
    }

    public Value getDiscriminator() {
        return this.getSuperclass().getDiscriminator();
    }

    public boolean isMutable() {
        return this.getSuperclass().isMutable();
    }

    public boolean isInherited() {
        return true;
    }

    public boolean isPolymorphic() {
        return true;
    }

    public void addProperty(Property p) {
        super.addProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    public void addMappedsuperClassProperty(Property p) {
        super.addMappedsuperclassProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    public void addJoin(Join j) {
        super.addJoin(j);
        this.getSuperclass().addSubclassJoin(j);
    }

    public Iterator getPropertyClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getPropertyClosureIterator(), this.getPropertyIterator());
    }

    public Iterator getTableClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getTableClosureIterator(), new SingletonIterator(this.getTable()));
    }

    public Iterator getKeyClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getKeyClosureIterator(), new SingletonIterator(this.getKey()));
    }

    protected void addSubclassProperty(Property p) {
        super.addSubclassProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    protected void addSubclassJoin(Join j) {
        super.addSubclassJoin(j);
        this.getSuperclass().addSubclassJoin(j);
    }

    protected void addSubclassTable(Table table) {
        super.addSubclassTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    public boolean isVersioned() {
        return this.getSuperclass().isVersioned();
    }

    public Property getVersion() {
        return this.getSuperclass().getVersion();
    }

    public Property getDeclaredVersion() {
        return null;
    }

    public boolean hasEmbeddedIdentifier() {
        return this.getSuperclass().hasEmbeddedIdentifier();
    }

    public Class getEntityPersisterClass() {
        if (this.classPersisterClass == null) {
            return this.getSuperclass().getEntityPersisterClass();
        }
        return this.classPersisterClass;
    }

    public Table getRootTable() {
        return this.getSuperclass().getRootTable();
    }

    public KeyValue getKey() {
        return this.getSuperclass().getIdentifier();
    }

    public boolean isExplicitPolymorphism() {
        return this.getSuperclass().isExplicitPolymorphism();
    }

    public void setSuperclass(PersistentClass superclass) {
        this.superclass = superclass;
    }

    public String getWhere() {
        return this.getSuperclass().getWhere();
    }

    public boolean isJoinedSubclass() {
        return this.getTable() != this.getRootTable();
    }

    public void createForeignKey() {
        if (!this.isJoinedSubclass()) {
            throw new AssertionFailure("not a joined-subclass");
        }
        this.getKey().createForeignKeyOfEntity(this.getSuperclass().getEntityName());
    }

    public void setEntityPersisterClass(Class classPersisterClass) {
        this.classPersisterClass = classPersisterClass;
    }

    public boolean isLazyPropertiesCacheable() {
        return this.getSuperclass().isLazyPropertiesCacheable();
    }

    public int getJoinClosureSpan() {
        return this.getSuperclass().getJoinClosureSpan() + super.getJoinClosureSpan();
    }

    public int getPropertyClosureSpan() {
        return this.getSuperclass().getPropertyClosureSpan() + super.getPropertyClosureSpan();
    }

    public Iterator getJoinClosureIterator() {
        return new JoinedIterator(this.getSuperclass().getJoinClosureIterator(), super.getJoinClosureIterator());
    }

    public boolean isClassOrSuperclassJoin(Join join) {
        return super.isClassOrSuperclassJoin(join) || this.getSuperclass().isClassOrSuperclassJoin(join);
    }

    public boolean isClassOrSuperclassTable(Table table) {
        return super.isClassOrSuperclassTable(table) || this.getSuperclass().isClassOrSuperclassTable(table);
    }

    public Table getTable() {
        return this.getSuperclass().getTable();
    }

    public boolean isForceDiscriminator() {
        return this.getSuperclass().isForceDiscriminator();
    }

    public boolean isDiscriminatorInsertable() {
        return this.getSuperclass().isDiscriminatorInsertable();
    }

    public Set getSynchronizedTables() {
        HashSet result = new HashSet();
        result.addAll(this.synchronizedTables);
        result.addAll(this.getSuperclass().getSynchronizedTables());
        return result;
    }

    public Object accept(PersistentClassVisitor mv) {
        return mv.accept(this);
    }

    public Map getFilterMap() {
        return this.getSuperclass().getFilterMap();
    }

    public boolean hasSubselectLoadableCollections() {
        return super.hasSubselectLoadableCollections() || this.getSuperclass().hasSubselectLoadableCollections();
    }

    public String getTuplizerImplClassName(EntityMode mode) {
        String impl = super.getTuplizerImplClassName(mode);
        if (impl == null) {
            impl = this.getSuperclass().getTuplizerImplClassName(mode);
        }
        return impl;
    }

    public Map getTuplizerMap() {
        Map specificTuplizerDefs = super.getTuplizerMap();
        Map superclassTuplizerDefs = this.getSuperclass().getTuplizerMap();
        if (specificTuplizerDefs == null && superclassTuplizerDefs == null) {
            return null;
        }
        HashMap combined = new HashMap();
        if (superclassTuplizerDefs != null) {
            combined.putAll(superclassTuplizerDefs);
        }
        if (specificTuplizerDefs != null) {
            combined.putAll(specificTuplizerDefs);
        }
        return Collections.unmodifiableMap(combined);
    }

    public Component getIdentifierMapper() {
        return this.superclass.getIdentifierMapper();
    }

    public int getOptimisticLockMode() {
        return this.superclass.getOptimisticLockMode();
    }
}

