/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class PessimisticWriteSelectLockingStrategy
implements LockingStrategy {
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public PessimisticWriteSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        this.sql = this.generateLockString(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        String sql = this.sql;
        if (timeout == 0) {
            sql = this.generateLockString(0);
        } else if (timeout > 0) {
            sql = this.generateLockString(timeout);
        }
        SessionFactoryImplementor factory = session.getFactory();
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
            try {
                this.lockable.getIdentifierType().nullSafeSet(st, id, 1, session);
                if (this.lockable.isVersioned()) {
                    this.lockable.getVersionType().nullSafeSet(st, version, this.lockable.getIdentifierType().getColumnSpan(factory) + 1, session);
                }
                ResultSet rs = st.executeQuery();
                try {
                    if (!rs.next()) {
                        if (factory.getStatistics().isStatisticsEnabled()) {
                            factory.getStatisticsImplementor().optimisticFailure(this.lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(this.lockable.getEntityName(), id);
                    }
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            {
            }
        }
        catch (SQLException sqle) {
            JDBCException e = JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, id, session.getFactory()), sql);
            throw new PessimisticLockException("could not obtain pessimistic lock", e, object);
        }
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected String generateLockString(int lockTimeout) {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        LockOptions lockOptions = new LockOptions(this.lockMode);
        lockOptions.setTimeOut(lockTimeout);
        SimpleSelect select = new SimpleSelect(factory.getDialect()).setLockOptions(lockOptions).setTableName(this.lockable.getRootTableName()).addColumn(this.lockable.getRootTableIdentifierColumnNames()[0]).addCondition(this.lockable.getRootTableIdentifierColumnNames(), "=?");
        if (this.lockable.isVersioned()) {
            select.addCondition(this.lockable.getVersionColumnName(), "=?");
        }
        if (factory.getSettings().isCommentsEnabled()) {
            select.setComment(this.lockMode + " lock " + this.lockable.getEntityName());
        }
        return select.toStatementString();
    }
}

