/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.io.Closeable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class ExecutingExecutionStrategy
implements ExecutionStrategy {
    private static final Logger LOG = Log.getLogger(ExecutingExecutionStrategy.class);
    private final Executor _executor;
    private final Invocable.InvocationType _preferredInvocationType;

    protected ExecutingExecutionStrategy(Executor executor, Invocable.InvocationType preferred) {
        this._executor = executor;
        this._preferredInvocationType = preferred;
    }

    public Invocable.InvocationType getPreferredInvocationType() {
        return this._preferredInvocationType;
    }

    public void invoke(Runnable task) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} invoke  {}", this, task);
        }
        Invocable.invokePreferred(task, this._preferredInvocationType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} invoked {}", this, task);
        }
    }

    protected boolean execute(Runnable task) {
        try {
            this._executor.execute(Invocable.asPreferred(task, this._preferredInvocationType));
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.debug(e);
            LOG.warn("Rejected execution of {}", task);
            try {
                if (task instanceof Closeable) {
                    ((Closeable)((Object)task)).close();
                }
            }
            catch (Exception x) {
                e.addSuppressed(x);
                LOG.warn(e);
            }
            return false;
        }
    }
}

