/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.common.extensions.compress.CompressionMethod;

public class DeflateCompressionMethod
implements CompressionMethod {
    private static final int DEFAULT_BUFFER_SIZE = 62464;
    private static final Logger LOG = Log.getLogger(DeflateCompressionMethod.class);
    private int bufferSize = 65536;
    private final DeflaterProcess compress;
    private final InflaterProcess decompress;

    public DeflateCompressionMethod() {
        boolean nowrap = true;
        this.compress = new DeflaterProcess(nowrap);
        this.decompress = new InflaterProcess(nowrap);
    }

    @Override
    public CompressionMethod.Process compress() {
        return this.compress;
    }

    @Override
    public CompressionMethod.Process decompress() {
        return this.decompress;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        if (size < 64) {
            throw new IllegalArgumentException("Buffer Size [" + size + "] cannot be less than 64 bytes");
        }
        this.bufferSize = size;
        this.compress.setBufferSize(this.bufferSize);
        this.decompress.setBufferSize(this.bufferSize);
    }

    private static class InflaterProcess
    implements CompressionMethod.Process {
        private static final byte[] TAIL = new byte[]{0, 0, -1, -1};
        private final Inflater inflater;
        private int bufferSize = 62464;

        public InflaterProcess(boolean nowrap) {
            this.inflater = new Inflater(nowrap);
        }

        @Override
        public void begin() {
            this.inflater.reset();
        }

        @Override
        public void end() {
            this.inflater.reset();
        }

        @Override
        public void input(ByteBuffer input) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("inflate: {}", BufferUtil.toDetailString(input));
                LOG.debug("Input Data: {}", TypeUtil.toHexString(BufferUtil.toArray(input)));
            }
            int len = input.remaining() + 4;
            byte[] raw = new byte[len];
            int inlen = input.remaining();
            input.slice().get(raw, 0, inlen);
            System.arraycopy(TAIL, 0, raw, inlen, TAIL.length);
            this.inflater.setInput(raw, 0, raw.length);
        }

        @Override
        public boolean isDone() {
            return this.inflater.getRemaining() <= 0 || this.inflater.finished();
        }

        @Override
        public ByteBuffer process() {
            byte[] buf = new byte[this.bufferSize];
            try {
                int inflated = this.inflater.inflate(buf);
                if (inflated == 0) {
                    return null;
                }
                ByteBuffer ret = BufferUtil.toBuffer(buf, 0, inflated);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("uncompressed={}", BufferUtil.toDetailString(ret));
                }
                return ret;
            }
            catch (DataFormatException e) {
                LOG.warn(e);
                throw new BadPayloadException(e);
            }
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }
    }

    private static class DeflaterProcess
    implements CompressionMethod.Process {
        private static final boolean BFINAL_HACK = Boolean.parseBoolean(System.getProperty("jetty.websocket.bfinal.hack", "true"));
        private final Deflater deflater;
        private int bufferSize = 62464;

        public DeflaterProcess(boolean nowrap) {
            this.deflater = new Deflater(9, nowrap);
            this.deflater.setStrategy(0);
        }

        @Override
        public void begin() {
            this.deflater.reset();
        }

        @Override
        public void end() {
            this.deflater.reset();
        }

        @Override
        public void input(ByteBuffer input) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("input: {}", BufferUtil.toDetailString(input));
            }
            byte[] raw = BufferUtil.toArray(input);
            this.deflater.setInput(raw, 0, raw.length);
            this.deflater.finish();
        }

        @Override
        public boolean isDone() {
            return this.deflater.finished();
        }

        @Override
        public ByteBuffer process() {
            byte b0;
            ByteBuffer buf = ByteBuffer.allocate(this.bufferSize);
            BufferUtil.clearToFill(buf);
            while (!this.deflater.finished()) {
                byte[] out = new byte[this.bufferSize];
                int len = this.deflater.deflate(out, 0, out.length, 2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deflater: finished={}, needsInput={}, len={}", this.deflater.finished(), this.deflater.needsInput(), len);
                }
                buf.put(out, 0, len);
            }
            BufferUtil.flipToFlush(buf, 0);
            if (BFINAL_HACK && ((b0 = buf.get(0)) & 1) != 0) {
                b0 = (byte)(b0 ^ 1);
                buf.put(0, b0);
            }
            return buf;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }
    }
}

