/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.Iterator;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class MavenQuickStartConfiguration
extends QuickStartConfiguration {
    private static final Logger LOG = Log.getLogger(QuickStartConfiguration.class);
    private Resource _quickStartWebXml;

    public void setQuickStartWebXml(Resource r) {
        this._quickStartWebXml = r;
    }

    public Resource getQuickStartWebXml(WebAppContext context) throws Exception {
        return this._quickStartWebXml;
    }

    public void configure(WebAppContext context) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting up classpath ...", new Object[0]);
            }
            Iterator<File> itor = jwac.getClassPathFiles().iterator();
            while (itor.hasNext()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(itor.next().getCanonicalPath());
            }
        }
        super.configure(context);
        String[] existingServerClasses = context.getServerClasses();
        String[] newServerClasses = new String[2 + (existingServerClasses == null ? 0 : existingServerClasses.length)];
        newServerClasses[0] = "org.apache.maven.";
        newServerClasses[1] = "org.codehaus.plexus.";
        System.arraycopy(existingServerClasses, 0, newServerClasses, 2, existingServerClasses.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server classes:", new Object[0]);
            for (int i = 0; i < newServerClasses.length; ++i) {
                LOG.debug(newServerClasses[i], new Object[0]);
            }
        }
        context.setServerClasses(newServerClasses);
    }
}

