/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableCharShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortCharMap;
import org.eclipse.collections.api.map.primitive.ShortCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortCharPair;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.CharShortMaps;
import org.eclipse.collections.impl.iterator.ImmutableEmptyCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableShortCharSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyShortIterate;

final class ImmutableShortCharEmptyMap
implements ImmutableShortCharMap,
Serializable {
    static final ImmutableShortCharMap INSTANCE = new ImmutableShortCharEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';

    ImmutableShortCharEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public char get(short key) {
        return '\u0000';
    }

    public char getIfAbsent(short key, char ifAbsent) {
        return ifAbsent;
    }

    public char getOrThrow(short key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return false;
    }

    public boolean containsValue(char value) {
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
    }

    public void forEachKey(ShortProcedure procedure) {
    }

    public void forEachKeyValue(ShortCharProcedure procedure) {
    }

    public LazyShortIterable keysView() {
        return LazyShortIterate.empty();
    }

    public RichIterable<ShortCharPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableCharShortMap flipUniqueValues() {
        return CharShortMaps.immutable.empty();
    }

    public ImmutableShortCharMap select(ShortCharPredicate predicate) {
        return this;
    }

    public ImmutableShortCharMap reject(ShortCharPredicate predicate) {
        return this;
    }

    public ImmutableShortCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return ImmutableEmptyCharIterator.INSTANCE;
    }

    public void forEach(CharProcedure procedure) {
    }

    public void each(CharProcedure procedure) {
    }

    public int count(CharPredicate predicate) {
        return 0;
    }

    public long sum() {
        return 0L;
    }

    public char min() {
        throw new NoSuchElementException();
    }

    public char max() {
        throw new NoSuchElementException();
    }

    public char maxIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public char minIfEmpty(char defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public char[] toSortedArray() {
        return new char[0];
    }

    public MutableCharList toSortedList() {
        return new CharArrayList();
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return true;
    }

    public ImmutableCharBag select(CharPredicate predicate) {
        return CharBags.immutable.empty();
    }

    public ImmutableCharBag reject(CharPredicate predicate) {
        return CharBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public RichIterable<CharIterable> chunk(int size) {
        return Lists.immutable.empty();
    }

    public char[] toArray() {
        return new char[0];
    }

    public char[] toArray(char[] target) {
        return target;
    }

    public boolean contains(char value) {
        return false;
    }

    public boolean containsAll(char ... source) {
        return source.length == 0;
    }

    public boolean containsAll(CharIterable source) {
        return source.isEmpty();
    }

    public MutableCharList toList() {
        return new CharArrayList();
    }

    public MutableCharSet toSet() {
        return new CharHashSet();
    }

    public MutableCharBag toBag() {
        return new CharHashBag();
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableShortCharMap newWithKeyValue(short key, char value) {
        return new ImmutableShortCharSingletonMap(key, value);
    }

    public ImmutableShortCharMap newWithoutKey(short key) {
        return this;
    }

    public ImmutableShortCharMap newWithoutAllKeys(ShortIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(new ShortHashSet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of((MutableCharCollection)new CharArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortCharMap)) {
            return false;
        }
        ShortCharMap map = (ShortCharMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

