/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.util.stream.IntStream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableIntListFactory;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableIntListFactoryImpl implements MutableIntListFactory
{
    INSTANCE;


    public MutableIntList empty() {
        return new IntArrayList();
    }

    public MutableIntList of() {
        return this.empty();
    }

    public MutableIntList with() {
        return this.empty();
    }

    public MutableIntList withInitialCapacity(int capacity) {
        return new IntArrayList(capacity);
    }

    public MutableIntList of(int ... items) {
        return this.with(items);
    }

    public MutableIntList with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return IntArrayList.newListWith(items);
    }

    public MutableIntList ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public MutableIntList withAll(IntIterable items) {
        return IntArrayList.newList(items);
    }

    public MutableIntList ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    public MutableIntList withAll(Iterable<Integer> iterable) {
        return Iterate.collectInt(iterable, Integer::intValue, IntLists.mutable.empty());
    }

    public MutableIntList ofAll(IntStream items) {
        return this.withAll(items);
    }

    public MutableIntList withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

