/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalPercentRank
extends AggrFunction {
    @Override
    public String getName() {
        return "PERCENTRANK";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public int getNumberOfPasses() {
        return 2;
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalPercentRank.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalPercentRank.displayName");
    }

    private static class MyAccumulator
    extends RunningAccumulator {
        private Double sum;
        private List cachedValues;
        private int passCount = 0;
        private Object[] sortedObjs;

        private MyAccumulator() {
        }

        @Override
        public void start() {
            if (this.passCount == 0) {
                this.cachedValues = new ArrayList();
                this.sum = new Double(0.0);
            }
            ++this.passCount;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (this.passCount == 1) {
                if (args[0] != null) {
                    this.cachedValues.add(args[0]);
                } else {
                    this.cachedValues.add(RankAggregationUtil.getNullObject());
                }
            } else {
                Object compareValue = args[0] != null ? args[0] : RankAggregationUtil.getNullObject();
                this.sum = new Double(this.getPercentRank(compareValue, this.sortedObjs));
            }
        }

        @Override
        public void finish() throws DataException {
            if (this.passCount == 1) {
                this.sortedObjs = this.cachedValues.toArray();
                RankAggregationUtil.sortArray(this.sortedObjs);
            }
        }

        private double getPercentRank(Object o, Object[] objs) {
            double smaller = -1.0;
            int i = 0;
            while (i < objs.length) {
                if (o.equals(objs[i]) && smaller == -1.0) {
                    smaller = i;
                }
                ++i;
            }
            if (smaller == -1.0) {
                return 0.0;
            }
            if (objs.length == 1) {
                return 1.0;
            }
            double result = smaller / (double)(objs.length - 1);
            return result;
        }

        @Override
        public Object getValue() throws DataException {
            return this.sum;
        }
    }
}

