/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.PrivateStyleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.DateTimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.NumberFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.StringFormatValue;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class TOCHandle
extends StructureHandle {
    public static final String defaultTOCPrefixName = "TOC-level-";

    public TOCHandle(DesignElementHandle element, StructureContext context) {
        super(element, context);
    }

    public TOCHandle(DesignElementHandle element, MemberRef context) {
        super(element, context);
    }

    public String getExpression() {
        return this.getStringProperty("expressionValue");
    }

    public void setExpression(String expression) throws SemanticException {
        this.setProperty("expressionValue", expression);
    }

    public String getStyleName() {
        StyleHandle handle = this.getStyle();
        if (handle == null) {
            return null;
        }
        return handle.getName();
    }

    public void setStyleName(String styleName) throws SemanticException {
        this.setProperty("TOCStyle", styleName);
    }

    private StyleHandle getStyle() {
        ElementRefValue refValue;
        Object value = ((Structure)this.getStructure()).getLocalProperty(this.getModule(), "TOCStyle");
        if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved()) {
            Style style = (Style)refValue.getElement();
            return (SharedStyleHandle)style.getHandle(style.getRoot());
        }
        return null;
    }

    public PrivateStyleHandle getPrivateStyle() {
        return new PrivateStyleHandle(this.getModule(), this.getElement());
    }

    public String getBorderTopStyle() {
        Object value = this.getProperty("borderTopStyle");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderTopStyle();
        }
        return (String)value;
    }

    public DimensionHandle getBorderTopWidth() {
        Object value = this.getProperty("borderTopWidth");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderTopWidth();
        }
        return this.doGetDimensionHandle("borderTopWidth");
    }

    private DimensionHandle doGetDimensionHandle(String memberName) {
        return new DimensionHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, memberName));
    }

    private ColorHandle doGetColorHandle(String memberName) {
        return new ColorHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, memberName));
    }

    public ColorHandle getBorderTopColor() {
        Object value = this.getProperty("borderTopColor");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderTopColor();
        }
        return this.doGetColorHandle("borderTopColor");
    }

    public String getBorderLeftStyle() {
        Object value = this.getProperty("borderLeftStyle");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderLeftStyle();
        }
        return (String)value;
    }

    public DimensionHandle getBorderLeftWidth() {
        Object value = this.getProperty("borderLeftWidth");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderLeftWidth();
        }
        return this.doGetDimensionHandle("borderLeftWidth");
    }

    public ColorHandle getBorderLeftColor() {
        Object value = this.getProperty("borderLeftColor");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderLeftColor();
        }
        return this.doGetColorHandle("borderLeftColor");
    }

    public String getBorderBottomStyle() {
        Object value = this.getProperty("borderBottomStyle");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderBottomStyle();
        }
        return (String)value;
    }

    public DimensionHandle getBorderBottomWidth() {
        Object value = this.getProperty("borderBottomWidth");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderBottomWidth();
        }
        return this.doGetDimensionHandle("borderBottomWidth");
    }

    public ColorHandle getBorderBottomColor() {
        Object value = this.getProperty("borderBottomColor");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderBottomColor();
        }
        return this.doGetColorHandle("borderBottomColor");
    }

    public String getBorderRightStyle() {
        Object value = this.getProperty("borderRightStyle");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderRightStyle();
        }
        return (String)value;
    }

    public DimensionHandle getBorderRightWidth() {
        Object value = this.getProperty("borderRightWidth");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderRightWidth();
        }
        return this.doGetDimensionHandle("borderRightWidth");
    }

    public ColorHandle getBorderRightColor() {
        Object value = this.getProperty("borderRightColor");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBorderRightColor();
        }
        return this.doGetColorHandle("borderRightColor");
    }

    public ColorHandle getBackgroundColor() {
        Object value = this.getProperty("backgroundColor");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getBackgroundColor();
        }
        return this.doGetColorHandle("backgroundColor");
    }

    public String getDateTimeFormat() {
        Object value = this.getProperty("dateTimeFormat");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getDateTimeFormat();
        }
        return ((DateTimeFormatValue)value).getPattern();
    }

    public String getDateTimeFormatCategory() {
        Object value = this.getProperty("dateTimeFormat");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getDateTimeFormatCategory();
        }
        assert (value instanceof DateTimeFormatValue);
        return ((DateTimeFormatValue)value).getCategory();
    }

    public String getNumberFormat() {
        Object value = this.getProperty("numberFormat");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getNumberFormat();
        }
        assert (value instanceof NumberFormatValue);
        return ((NumberFormatValue)value).getPattern();
    }

    public String getNumberFormatCategory() {
        Object value = this.getProperty("numberFormat");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getNumberFormatCategory();
        }
        assert (value instanceof NumberFormatValue);
        return ((NumberFormatValue)value).getCategory();
    }

    public String getNumberAlign() {
        Object value = this.getProperty("numberAlign");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getVerticalAlign();
        }
        return (String)value;
    }

    public String getStringFormat() {
        Object value = this.getProperty("stringFormat");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getStringFormat();
        }
        assert (value instanceof StringFormatValue);
        return ((StringFormatValue)value).getPattern();
    }

    public String getStringFormatCategory() {
        Object value = this.getProperty("stringFormat");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getStringFormatCategory();
        }
        assert (value instanceof StringFormatValue);
        return ((StringFormatValue)value).getCategory();
    }

    public FontHandle getFontFamily() {
        Object value = this.getProperty("fontFamily");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getFontFamilyHandle();
        }
        return this.doGetFontHandle("fontFamily");
    }

    private FontHandle doGetFontHandle(String memberName) {
        return new FontHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, memberName));
    }

    public DimensionHandle getFontSize() {
        Object value = this.getProperty("fontSize");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getFontSize();
        }
        return this.doGetDimensionHandle("fontSize");
    }

    public String getFontStyle() {
        Object value = this.getProperty("fontStyle");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getFontStyle();
        }
        return (String)value;
    }

    public String getFontWeight() {
        Object value = this.getProperty("fontWeight");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getFontWeight();
        }
        return (String)value;
    }

    public String getFontVariant() {
        Object value = this.getProperty("fontVariant");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getFontVariant();
        }
        return (String)value;
    }

    public ColorHandle getColor() {
        Object value = this.getProperty("color");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getColor();
        }
        return this.doGetColorHandle("color");
    }

    public String getTextUnderline() {
        Object value = this.getProperty("textUnderline");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextUnderline();
        }
        return (String)value;
    }

    public String getTextOverline() {
        Object value = this.getProperty("textOverline");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextOverline();
        }
        return (String)value;
    }

    public String getTextLineThrough() {
        Object value = this.getProperty("textLineThrough");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextLineThrough();
        }
        return (String)value;
    }

    public String getTextAlign() {
        Object value = this.getProperty("textAlign");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextAlign();
        }
        return (String)value;
    }

    public String getTextDirection() {
        Object value = this.getProperty("bidiTextDirection");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextDirection();
        }
        return (String)value;
    }

    public void setTextDirection(String value) throws SemanticException {
        this.setProperty("bidiTextDirection", value);
    }

    public DimensionHandle getTextIndent() {
        Object value = this.getProperty("textIndent");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextIndent();
        }
        return this.doGetDimensionHandle("textIndent");
    }

    public String getTextTransform() {
        Object value = this.getProperty("textTransform");
        if (value == null) {
            StyleHandle style = this.getStyle();
            if (style == null) {
                return null;
            }
            return style.getTextTransform();
        }
        return (String)value;
    }
}

