/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.RowBandAction;
import org.eclipse.birt.report.model.api.RowBandAdapter;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class RowBandInsertAndPasteAction
extends RowBandAction {
    RowBandInsertAndPasteAction(RowBandAdapter adapter) {
        super(adapter);
    }

    protected boolean canInsertAndPaste(TableRow clonedRow, RowOperationParameters parameters) {
        if (this.adapter.hasParent()) {
            return false;
        }
        int destIndex = parameters.getDestIndex();
        int desColumnCount = this.adapter.getColumnCount();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        if (slotHandle == null) {
            return false;
        }
        if (destIndex < 0 || destIndex >= slotHandle.getCount()) {
            return false;
        }
        int count = this.adapter.computeRowCount(clonedRow);
        if (count != desColumnCount) {
            return false;
        }
        RowHandle destHandle = (RowHandle)slotHandle.get(destIndex);
        return this.isRectangleArea(destHandle) && !this.containsRowSpan(destHandle);
    }

    protected void doInsertAndPaste(TableRow copiedRow, RowOperationParameters parameters) throws SemanticException {
        if (!this.canInsertAndPaste(copiedRow, parameters)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.ROW_INSERTANDPASTE_FORBIDDEN");
        }
        int destIndex = parameters.getDestIndex();
        SlotHandle slotHandle = this.getSlotHandle(parameters);
        ActivityStack stack = this.adapter.getModule().getActivityStack();
        try {
            stack.startTrans(CommandLabelFactory.getCommandLabel("Message.InsertAndPasteRow"));
            this.adapter.getModule().getModuleHandle().rename(copiedRow.getHandle(slotHandle.getModule()));
            slotHandle.paste(copiedRow.getHandle(slotHandle.getModule()), destIndex + 1);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

