/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.RenderOptionDefn;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractEmitterDescriptor
implements IEmitterDescriptor {
    protected Map initParams = null;
    protected Locale locale;
    protected Map<String, RenderOptionDefn> renderOptionDefns = new HashMap<String, RenderOptionDefn>();
    protected IConfigurableOption[] options;
    private static final String OPTIONS_CONFIG_FILE = "RenderDefaults.cfg";
    private static final String RENDER_OPTIONS_FILE = "RenderOptions.xml";
    private static final String OPTION_QNAME = "option";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_DEFAULT = "default";
    private static final String OPTION_ENABLED = "enabled";

    public void setInitParameters(Map params) {
        this.initParams = params;
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.initOptions();
        }
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getID() {
        return null;
    }

    protected abstract void initOptions();

    protected void applyDefaultValues() {
        IConfigurableOption[] iConfigurableOptionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurableOption option = iConfigurableOptionArray[n2];
            this.applyDefaultValue(option);
            ++n2;
        }
    }

    protected boolean loadDefaultValues(String bundleName) {
        try {
            InputStream in;
            URL url = this.getResourceURL(bundleName, OPTIONS_CONFIG_FILE);
            if (url != null) {
                in = url.openStream();
                Properties defaultValues = new Properties();
                defaultValues.load(in);
                for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
                    String name = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    this.renderOptionDefns.put(name, new RenderOptionDefn(name, value, true));
                }
                in.close();
            }
            if ((url = this.getResourceURL(bundleName, RENDER_OPTIONS_FILE)) != null) {
                in = url.openStream();
                this.doLoadDefaultValues(in);
                in.close();
            }
        }
        catch (Exception exception) {
            this.renderOptionDefns = null;
        }
        return this.renderOptionDefns != null && !this.renderOptionDefns.isEmpty();
    }

    private void doLoadDefaultValues(InputStream in) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        try {
            parser.parse(in, (DefaultHandler)new RenderOptionHandler());
        }
        catch (Throwable throwable) {
            try {
                parser.reset();
                parser = null;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            parser.reset();
            parser = null;
        }
        catch (Exception exception) {}
    }

    private void applyDefaultValue(IConfigurableOption option) {
        if (this.renderOptionDefns == null || this.renderOptionDefns.isEmpty()) {
            return;
        }
        RenderOptionDefn defn = this.renderOptionDefns.get(option.getName());
        if (defn != null) {
            String value = defn.getValue();
            ConfigurableOption optionImpl = (ConfigurableOption)option;
            optionImpl.setEnabled(defn.isEnabled());
            switch (option.getDataType()) {
                case STRING: {
                    optionImpl.setDefaultValue(value);
                    break;
                }
                case BOOLEAN: {
                    optionImpl.setDefaultValue(Boolean.valueOf(value));
                    break;
                }
                case INTEGER: {
                    Integer intValue = null;
                    try {
                        intValue = Integer.decode(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    optionImpl.setDefaultValue(intValue);
                    break;
                }
                case FLOAT: {
                    Float floatValue = null;
                    try {
                        floatValue = Float.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                    optionImpl.setDefaultValue(floatValue);
                    break;
                }
            }
        }
    }

    private URL getResourceURL(String bundleName, String resourceName) {
        IBundle bundle = Platform.getBundle(bundleName);
        if (bundle != null) {
            return bundle.getEntry(resourceName);
        }
        return null;
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private class RenderOptionHandler
    extends DefaultHandler {
        private RenderOptionHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name;
            if (AbstractEmitterDescriptor.OPTION_QNAME.equalsIgnoreCase(qName) && !AbstractEmitterDescriptor.this.isEmpty(name = attributes.getValue(AbstractEmitterDescriptor.OPTION_NAME))) {
                String defualt = attributes.getValue(AbstractEmitterDescriptor.OPTION_DEFAULT);
                Boolean enabled = Boolean.TRUE;
                String enabledStr = attributes.getValue(AbstractEmitterDescriptor.OPTION_ENABLED);
                if (!AbstractEmitterDescriptor.this.isEmpty(enabledStr)) {
                    enabled = Boolean.valueOf(enabledStr);
                }
                AbstractEmitterDescriptor.this.renderOptionDefns.put(name, new RenderOptionDefn(name, defualt, enabled));
            }
        }
    }
}

