/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ExtensionPropertyDefinitionEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.validators.ValidationExecutor;
import org.eclipse.birt.report.model.validators.ValidationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyRecordImpl
extends SimpleRecord {
    protected DesignElement element = null;
    protected ElementPropertyDefn propDefn = null;
    protected Object oldValue = null;
    protected Object newValue = null;

    public PropertyRecordImpl(DesignElement propertyOwner, String name, Object value) {
        assert (propertyOwner != null);
        this.element = propertyOwner;
        assert (name != null);
        this.propDefn = this.element.getPropertyDefn(name);
        assert (this.propDefn != null);
        assert (!this.propDefn.isIntrinsic());
        this.newValue = value;
        this.oldValue = this.copyLocalValue(propertyOwner.getLocalProperty(null, this.propDefn));
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
    }

    public PropertyRecordImpl(DesignElement propertyOwner, ElementPropertyDefn prop, Object value) {
        assert (propertyOwner != null);
        this.propDefn = prop;
        assert (this.propDefn != null);
        this.element = propertyOwner;
        this.newValue = value;
        this.oldValue = this.copyLocalValue(propertyOwner.getLocalProperty(null, this.propDefn));
        this.label = CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{this.propDefn.getDisplayName()});
    }

    private Object copyLocalValue(Object localValue) {
        if (localValue instanceof List) {
            ArrayList newValue = new ArrayList();
            newValue.addAll((List)localValue);
            return newValue;
        }
        return localValue;
    }

    @Override
    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    @Override
    public NotificationEvent getEvent() {
        IReportItem extElement;
        if (this.element instanceof ExtendedItem && (extElement = ((ExtendedItem)this.element).getExtendedElement()) != null && extElement.refreshPropertyDefinition()) {
            return new ExtensionPropertyDefinitionEvent(this.element);
        }
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.propDefn.getName());
    }

    @Override
    protected void perform(boolean undo) {
        Object value = null;
        Object tmpOldValue = null;
        if (!undo) {
            value = this.newValue;
            tmpOldValue = this.oldValue;
        } else {
            value = this.oldValue;
            tmpOldValue = this.newValue;
        }
        if (this.propDefn.getTypeCode() != 16) {
            if (this.propDefn.isEncryptable() && value instanceof String) {
                String encryption;
                String localEncryption = this.element.getLocalEncryptionID(this.propDefn);
                String string = encryption = localEncryption == null ? this.element.getEncryptionID(this.propDefn) : localEncryption;
                assert (encryption != null);
                value = EncryptionUtil.encrypt(this.propDefn, encryption, value);
                this.element.setProperty(this.propDefn, value);
                if (localEncryption == null) {
                    this.element.setEncryptionHelper(this.propDefn, encryption);
                }
                return;
            }
            this.element.setProperty(this.propDefn, value);
            if (this.element instanceof Cube) {
                Cube cube = (Cube)this.element;
                if (cube.isBoundWithLayout(this.propDefn)) {
                    cube.updateLayout(cube.getRoot());
                }
            } else if (this.element instanceof TabularDimension) {
                TabularDimension dimension = (TabularDimension)this.element;
                if ("internalDimensionRef".equals(this.propDefn.getName())) {
                    Module root = dimension.getRoot();
                    dimension.updateLayout(root);
                    if (root != null) {
                        root.manageId(dimension, true);
                    }
                }
            }
            return;
        }
        this.clearStructureContext(tmpOldValue);
        this.setupStructureContext(value);
        if (value == null || value instanceof List && ((List)value).isEmpty()) {
            this.element.setProperty(this.propDefn, value);
        }
    }

    private void setupStructureContext(Object values) {
        if (values == null) {
            return;
        }
        if (values instanceof List && ((List)values).isEmpty()) {
            return;
        }
        StructureContext context = new StructureContext(this.element, this.propDefn, null);
        if (values instanceof Structure) {
            context.add((Structure)values);
        } else if (values instanceof List) {
            int i = 0;
            while (i < ((List)values).size()) {
                context.add((Structure)((List)values).get(i));
                ++i;
            }
        }
    }

    private void clearStructureContext(Object values) {
        if (values == null) {
            return;
        }
        if (values instanceof List && ((List)values).isEmpty()) {
            return;
        }
        StructureContext context = new StructureContext(this.element, this.propDefn, null);
        if (values instanceof Structure) {
            context.remove((Structure)values);
            this.adjustReferredClients((Structure)values);
        } else if (values instanceof List) {
            ArrayList structs = new ArrayList();
            structs.addAll((List)values);
            int count = structs.size();
            int i = 0;
            while (i < count) {
                Structure struct = (Structure)structs.get(i);
                context.remove(struct);
                this.adjustReferredClients(struct);
                ++i;
            }
        }
    }

    private void adjustReferredClients(Structure struct) {
        Iterator<IPropertyDefn> propDefns = struct.getDefn().propertiesIterator();
        while (propDefns.hasNext()) {
            Object value;
            PropertyDefn propDefn = (PropertyDefn)propDefns.next();
            if (propDefn.getTypeCode() != 15 || (value = struct.getLocalProperty(this.element.getRoot(), propDefn)) == null || !((ElementRefValue)value).isResolved()) continue;
            struct.setProperty(propDefn, (Object)new ElementRefValue(((ElementRefValue)value).getLibraryNamespace(), ((ElementRefValue)value).getName()));
        }
    }

    @Override
    public List<ValidationNode> getValidators() {
        return ValidationExecutor.getValidationNodes(this.element, this.propDefn.getTriggerDefnSet(), false);
    }

    public ElementPropertyDefn getPropDefn() {
        return this.propDefn;
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        if (!(this.element instanceof Cell)) {
            return retValue;
        }
        String propName = this.propDefn.getName();
        if (!("colSpan".equalsIgnoreCase(propName) || "rowSpan".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName))) {
            return retValue;
        }
        ReportItem compoundElement = LayoutUtil.getCompoundContainer(this.element);
        if (compoundElement == null) {
            return retValue;
        }
        retValue.add(new LayoutRecordTask(compoundElement.getRoot(), compoundElement));
        return retValue;
    }
}

