/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

public class DataSetID {
    DataSetID parent;
    long rowId;
    String cellId;
    String queryName;
    String dataSetName;

    public DataSetID(DataSetID parent, long rowId, String queryName) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent can not be null!");
        }
        if (queryName == null) {
            throw new IllegalArgumentException("The queryName can not be null!");
        }
        this.parent = parent;
        this.rowId = rowId;
        this.queryName = queryName;
    }

    public DataSetID(DataSetID parent, String cellId, String queryName) {
        if (parent == null) {
            throw new IllegalArgumentException("The parent can not be null!");
        }
        if (queryName == null) {
            throw new IllegalArgumentException("The queryName can not be null!");
        }
        this.parent = parent;
        this.rowId = -1L;
        this.cellId = cellId;
        this.queryName = queryName;
    }

    public DataSetID getParentID() {
        return this.parent;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public long getRowID() {
        return this.rowId;
    }

    public String getCellID() {
        return this.cellId;
    }

    public DataSetID(String dataSetName) {
        if (dataSetName == null) {
            throw new IllegalArgumentException("The dataSetName can not be null!");
        }
        this.dataSetName = dataSetName;
    }

    public boolean equals(Object a) {
        if (a instanceof DataSetID) {
            DataSetID aid = (DataSetID)a;
            if (this.dataSetName != null) {
                return this.dataSetName.equals(aid.dataSetName);
            }
            if (this.rowId == aid.rowId && this.queryName.equals(aid.queryName)) {
                return this.parent.equals(aid.parent);
            }
        }
        return false;
    }

    void append(StringBuffer buffer) {
        if (this.parent != null) {
            buffer.append("{");
            this.parent.append(buffer);
            buffer.append("}.");
            buffer.append(this.rowId);
            buffer.append(".");
            buffer.append(this.queryName);
        } else {
            buffer.append(this.dataSetName);
        }
    }

    public String toString() {
        if (this.dataSetName != null) {
            return this.dataSetName;
        }
        StringBuffer buffer = new StringBuffer();
        this.append(buffer);
        return buffer.toString();
    }

    public static DataSetID parse(String dataSetId) {
        return DataSetID.parse(dataSetId.toCharArray(), 0, dataSetId.length());
    }

    public static DataSetID parse(char[] buffer, int offset, int length) {
        int ptr = offset + length - 1;
        while (ptr >= offset && buffer[ptr] != '.') {
            --ptr;
        }
        if (ptr >= offset && buffer[ptr] == '.') {
            String queryName = new String(buffer, ptr + 1, offset + length - ptr - 1);
            length = --ptr - offset + 1;
            while (ptr >= offset && buffer[ptr] != '.') {
                --ptr;
            }
            if (ptr >= offset && buffer[ptr] == '.') {
                DataSetID parent;
                String strRowId = new String(buffer, ptr + 1, offset + length - ptr - 1);
                if (--ptr >= offset && buffer[ptr] == '}' && buffer[offset] == '{' && --ptr >= ++offset && (parent = DataSetID.parse(buffer, offset, ptr - offset + 1)) != null) {
                    try {
                        long rowId = Long.parseLong(strRowId);
                        return new DataSetID(parent, rowId, queryName);
                    }
                    catch (Exception exception) {
                        return new DataSetID(parent, strRowId, queryName);
                    }
                }
            }
        }
        return new DataSetID(new String(buffer, offset, length));
    }
}

