/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggrFilterDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationRowAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.FilterUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.MultiKey;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.TopBottomFilterDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.ValueObject;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.ObjectArrayUtil;
import org.eclipse.birt.data.engine.olap.data.util.OrderedDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.SetUtil;
import org.eclipse.birt.data.engine.olap.util.filter.IJSDimensionFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSTopBottomFilterHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationFilterHelper {
    private Map dimensionMap;
    private List aggrFilters;
    private List topbottomFilters;
    private boolean isEmptyXtab;
    private IBindingValueFetcher fetcher;

    public AggregationFilterHelper(Cube cube, List jsFilterHelpers, IBindingValueFetcher bindingValueFetcher) {
        this.fetcher = bindingValueFetcher;
        this.populateDimensionLevels(cube);
        this.populateFilters(jsFilterHelpers);
    }

    public List generateLevelFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet) throws DataException {
        ArrayList levelFilterList;
        block4: {
            levelFilterList = new ArrayList();
            try {
                this.applyAggrFilters(aggregations, resultSet, levelFilterList);
                if (!this.isEmptyXtab) break block4;
                return null;
            }
            catch (IOException e) {
                throw new DataException("", e);
            }
        }
        this.applyTopBottomFilters(aggregations, resultSet, levelFilterList);
        if (levelFilterList.size() == 0) {
            return null;
        }
        return levelFilterList;
    }

    private void populateFilters(List jsFilterHelpers) {
        this.aggrFilters = new ArrayList();
        this.topbottomFilters = new ArrayList();
        for (IJSFilterHelper filterHelper : jsFilterHelpers) {
            if (filterHelper instanceof IJSDimensionFilterHelper) {
                IJSDimensionFilterHelper dimFilterHelper = (IJSDimensionFilterHelper)filterHelper;
                this.aggrFilters.add(new AggrFilterDefinition(dimFilterHelper));
                continue;
            }
            if (!(filterHelper instanceof IJSTopBottomFilterHelper)) continue;
            IJSTopBottomFilterHelper tbFilterHelper = (IJSTopBottomFilterHelper)filterHelper;
            this.topbottomFilters.add(new TopBottomFilterDefinition(tbFilterHelper));
        }
    }

    private void populateDimensionLevels(Cube cube) {
        this.dimensionMap = new HashMap();
        IDimension[] dimensions = cube.getDimesions();
        int i = 0;
        while (i < dimensions.length) {
            this.dimensionMap.put(dimensions[i].getName(), dimensions[i].getHierarchy().getLevels());
            ++i;
        }
    }

    private void applyAggrFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, List levelFilterList) throws DataException, IOException {
        for (AggrFilterDefinition filter : this.aggrFilters) {
            int j = 0;
            while (!this.isEmptyXtab && j < aggregations.length) {
                if (aggregations[j].getAggregationFunctions() != null && this.isMatch(aggregations[j], resultSet[j], filter)) {
                    this.applyAggrFilter(resultSet[j], filter, levelFilterList);
                }
                ++j;
            }
        }
    }

    private boolean isMatch(AggregationDefinition aggregation, IAggregationResultSet resultSet, AggrFilterDefinition filter) {
        return filter.getAggrLevels() == null && resultSet.getLevelIndex(filter.getTargetLevel()) >= 0 || FilterUtil.isEqualLevels(aggregation.getLevels(), filter.getAggrLevels());
    }

    private void applyAggrFilter(IAggregationResultSet resultSet, AggrFilterDefinition filter, List levelFilters) throws DataException, IOException {
        DimLevel targetLevel = filter.getTargetLevel();
        ILevel[] levelsOfDimension = this.getLevelsOfDimension(targetLevel.getDimensionName());
        int targetIndex = FilterUtil.getTargetLevelIndex(levelsOfDimension, targetLevel.getLevelName());
        ArrayList<Object[]> selKeyValueList = new ArrayList<Object[]>();
        Member[] preMembers = null;
        IJSDimensionFilterHelper filterHelper = (IJSDimensionFilterHelper)filter.getFilterHelper();
        AggregationRowAccessor row4filter = new AggregationRowAccessor(resultSet, this.fetcher);
        int k = 0;
        while (k < resultSet.length()) {
            resultSet.seek(k);
            boolean isSelect = filterHelper.evaluateFilter(row4filter);
            if (isSelect) {
                int levelIndex;
                Object[] levelKeyValue;
                Member[] members = this.getTargetDimMembers(targetLevel.getDimensionName(), resultSet);
                if (preMembers != null && !FilterUtil.shareParentLevels(members, preMembers, targetIndex)) {
                    LevelFilter levelFilter = this.toLevelFilter(targetLevel, selKeyValueList, preMembers, filterHelper);
                    levelFilters.add(levelFilter);
                    selKeyValueList.clear();
                }
                if ((levelKeyValue = resultSet.getLevelKeyValue(levelIndex = resultSet.getLevelIndex(targetLevel))) != null && levelKeyValue[0] != null) {
                    selKeyValueList.add(levelKeyValue);
                }
                preMembers = members;
            }
            ++k;
        }
        if (preMembers == null) {
            this.isEmptyXtab = true;
            return;
        }
        if (!selKeyValueList.isEmpty()) {
            LevelFilter levelFilter = this.toLevelFilter(targetLevel, selKeyValueList, preMembers, filterHelper);
            levelFilters.add(levelFilter);
        }
    }

    private boolean hasFiltersOnEdgeAggrResultSet(IAggregationResultSet rs) {
        AggrFilterDefinition filterDefinition;
        boolean result = false;
        int k = 0;
        while (k < this.topbottomFilters.size()) {
            filterDefinition = (TopBottomFilterDefinition)this.topbottomFilters.get(k);
            if (this.isMatch(rs.getAggregationDefinition(), rs, filterDefinition)) {
                return true;
            }
            ++k;
        }
        k = 0;
        while (k < this.aggrFilters.size()) {
            filterDefinition = (AggrFilterDefinition)this.aggrFilters.get(k);
            if (this.isMatch(rs.getAggregationDefinition(), rs, filterDefinition)) {
                return true;
            }
            ++k;
        }
        return result;
    }

    private List populateDistinctLevelKeyList(AggregationDefinition aggregation, IAggregationResultSet resultSet, TopBottomFilterDefinition filter) throws DataException {
        IJSTopBottomFilterHelper filterHelper = (IJSTopBottomFilterHelper)filter.getFilterHelper();
        int n = -1;
        if (!filterHelper.isPercent()) {
            n = (int)filterHelper.getN();
        }
        OrderedDiskArray aggrValueArray = new OrderedDiskArray(n, filterHelper.isTop());
        filter.getTargetLevel().getDimensionName();
        Object preValue = null;
        try {
            AggregationRowAccessor row4filter = new AggregationRowAccessor(resultSet, this.fetcher);
            int k = 0;
            while (k < resultSet.length()) {
                resultSet.seek(k);
                int levelIndex = resultSet.getLevelIndex(filter.getTargetLevel());
                Object[] levelKey = resultSet.getLevelKeyValue(levelIndex);
                Object aggrValue = filterHelper.evaluateFilterExpr(row4filter);
                if (levelKey != null && filterHelper.isQualifiedRow(row4filter) && CompareUtil.compare(preValue, aggrValue) != 0) {
                    aggrValueArray.add(aggrValue);
                }
                preValue = aggrValue;
                ++k;
            }
            return this.fetchDistictLevelKeys(aggrValueArray, filterHelper);
        }
        catch (IOException e) {
            throw new DataException("", e);
        }
    }

    private List fetchDistictLevelKeys(IDiskArray aggrValueArray, IJSTopBottomFilterHelper filterHelper) throws IOException {
        int start = 0;
        int end = aggrValueArray.size();
        if (filterHelper.isPercent()) {
            int size = aggrValueArray.size();
            int n = FilterUtil.getTargetN(size, filterHelper.getN());
            if (filterHelper.isTop()) {
                start = size - n;
            } else {
                end = n;
            }
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        int i = start;
        while (i < end) {
            Object aggrValue = aggrValueArray.get(i);
            resultList.add(aggrValue);
            ++i;
        }
        return resultList;
    }

    public IAggregationResultSet[] generateFilteredAggregationResultSet(IAggregationResultSet[] rs, List<Integer> affectedAggrResultSetIndex) throws IOException, DataException {
        IAggregationResultSet[] result = new IAggregationResultSet[rs.length];
        ArrayList levelFilterList = new ArrayList();
        int i = 0;
        while (i < rs.length) {
            BufferedStructureArray validRows;
            if (rs[i].getAggregationDefinition().getAggregationFunctions() == null && this.hasFiltersOnEdgeAggrResultSet(rs[i])) {
                AggregationRowAccessor row4filter = new AggregationRowAccessor(rs[i], this.fetcher);
                validRows = new BufferedStructureArray(AggregationResultRow.getCreator(), rs[i].length());
                List[] topBottomNFilterResultList = null;
                int[] targetLevelIndex = null;
                if (this.topbottomFilters.size() > 0) {
                    topBottomNFilterResultList = new List[this.topbottomFilters.size()];
                    targetLevelIndex = new int[this.topbottomFilters.size()];
                }
                int k = 0;
                while (k < this.topbottomFilters.size()) {
                    IJSTopBottomFilterHelper cfr_ignored_0 = (IJSTopBottomFilterHelper)((TopBottomFilterDefinition)this.topbottomFilters.get(k)).getFilterHelper();
                    topBottomNFilterResultList[k] = this.populateDistinctLevelKeyList(rs[i].getAggregationDefinition(), rs[i], (TopBottomFilterDefinition)this.topbottomFilters.get(k));
                    targetLevelIndex[k] = rs[i].getLevelIndex(((TopBottomFilterDefinition)this.topbottomFilters.get(k)).getTargetLevel());
                    ++k;
                }
                int j = 0;
                while (j < rs[i].length()) {
                    rs[i].seek(j);
                    boolean isFilterByAll = true;
                    int k2 = 0;
                    while (k2 < this.aggrFilters.size()) {
                        IJSDimensionFilterHelper filterHelper = (IJSDimensionFilterHelper)((AggrFilterDefinition)this.aggrFilters.get(k2)).getFilterHelper();
                        if (this.isMatch(rs[i].getAggregationDefinition(), rs[i], (AggrFilterDefinition)this.aggrFilters.get(k2)) && !filterHelper.evaluateFilter(row4filter)) {
                            isFilterByAll = false;
                            break;
                        }
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < this.topbottomFilters.size()) {
                        Member m;
                        IAggregationResultRow currentRow = rs[i].getCurrentRow();
                        if (targetLevelIndex[k2] >= 0 && !topBottomNFilterResultList[k2].contains((m = currentRow.getLevelMembers()[targetLevelIndex[k2]]).getKeyValues()[0])) {
                            isFilterByAll = false;
                            break;
                        }
                        ++k2;
                    }
                    if (isFilterByAll) {
                        validRows.add(rs[i].getCurrentRow());
                    }
                    ++j;
                }
                AggregationResultSet newAggrResultSet = new AggregationResultSet(rs[i].getAggregationDefinition(), rs[i].getAllLevels(), validRows, rs[i].getKeyNames(), rs[i].getAttributeNames());
                result[i] = newAggrResultSet;
            } else {
                boolean filtered = false;
                for (AggrFilterDefinition filter : this.aggrFilters) {
                    if (rs[i].getAggregationDefinition().getAggregationFunctions() == null || !this.isMatch(rs[i].getAggregationDefinition(), rs[i], filter) || filter.getAxisQualifierLevels() == null) continue;
                    this.applyAggrFilter(rs[i], filter, levelFilterList);
                    filtered = true;
                }
                for (AggrFilterDefinition filter : this.topbottomFilters) {
                    if (rs[i].getAggregationDefinition().getAggregationFunctions() == null || !this.isMatch(rs[i].getAggregationDefinition(), rs[i], filter) || filter.getAxisQualifierLevels() == null) continue;
                    this.applyTopBottomFilters(new AggregationDefinition[]{rs[i].getAggregationDefinition()}, new IAggregationResultSet[]{rs[i]}, levelFilterList);
                    filtered = true;
                }
                if (filtered && levelFilterList.size() > 0) {
                    validRows = new BufferedStructureArray(AggregationResultRow.getCreator(), rs[i].length());
                    int k = 0;
                    while (k < levelFilterList.size()) {
                        LevelFilter f = (LevelFilter)levelFilterList.get(k);
                        ISelection[] selections = f.getSelections();
                        int p = 0;
                        while (p < selections.length) {
                            ISelection select = selections[p];
                            DimLevel dim = new DimLevel(f.getDimensionName(), f.getLevelName());
                            int levelIndex = rs[i].getLevelIndex(dim);
                            if (levelIndex >= 0) {
                                int m = 0;
                                while (m < rs[i].length()) {
                                    rs[i].seek(m);
                                    Object[] obj = rs[i].getCurrentRow().getLevelMembers()[levelIndex].getKeyValues();
                                    if (select.isSelected(obj)) {
                                        validRows.add(rs[i].getCurrentRow());
                                    }
                                    ++m;
                                }
                            }
                            ++p;
                        }
                        ++k;
                    }
                    AggregationResultSet newAggrResultSet = new AggregationResultSet(rs[i].getAggregationDefinition(), rs[i].getAllLevels(), validRows, rs[i].getKeyNames(), rs[i].getAttributeNames());
                    result[i] = newAggrResultSet;
                    affectedAggrResultSetIndex.add(i);
                } else if (filtered && levelFilterList.size() == 0) {
                    AggregationResultSet newAggrResultSet = new AggregationResultSet(rs[i].getAggregationDefinition(), rs[i].getAllLevels(), new BufferedStructureArray(AggregationResultRow.getCreator(), rs[i].length()), rs[i].getKeyNames(), rs[i].getAttributeNames());
                    result[i] = newAggrResultSet;
                    affectedAggrResultSetIndex.add(i);
                } else {
                    result[i] = rs[i];
                }
            }
            ++i;
        }
        return result;
    }

    private Member[] getTargetDimMembers(String dimensionName, IAggregationResultSet resultSet) {
        ILevel[] levels = this.getLevelsOfDimension(dimensionName);
        Member[] members = new Member[levels.length];
        int i = 0;
        while (i < levels.length) {
            int levelIndex = resultSet.getLevelIndex(new DimLevel(dimensionName, levels[i].getName()));
            if (levelIndex >= 0) {
                Object[] values = resultSet.getLevelKeyValue(levelIndex);
                Object[][] objectArray = new Object[2][];
                objectArray[0] = values;
                Object[] fieldValues = ObjectArrayUtil.convert(objectArray);
                members[i] = (Member)Member.getCreator().createInstance(fieldValues);
            }
            ++i;
        }
        return members;
    }

    private LevelFilter toLevelFilter(DimLevel targetLevel, List selKeyValueList, Member[] dimMembers, IJSFilterHelper filterHelper) {
        Object[][] keyValues = new Object[selKeyValueList.size()][];
        int i = 0;
        while (i < selKeyValueList.size()) {
            keyValues[i] = (Object[])selKeyValueList.get(i);
            ++i;
        }
        ISelection selection = SelectionFactory.createMutiKeySelection(keyValues);
        LevelFilter levelFilter = new LevelFilter(targetLevel, new ISelection[]{selection});
        levelFilter.setDimMembers(dimMembers);
        levelFilter.setFilterHelper(filterHelper);
        return levelFilter;
    }

    private void applyTopBottomFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, List levelFilterList) throws DataException, IOException {
        int i = 0;
        while (i < aggregations.length) {
            if (aggregations[i].getAggregationFunctions() != null) {
                HashMap<DimLevel, Object[]> levelFilterMap = new HashMap<DimLevel, Object[]>();
                for (TopBottomFilterDefinition filter : this.topbottomFilters) {
                    if (!filter.getFilterHelper().isAggregationFilter() || !FilterUtil.isEqualLevels(aggregations[i].getLevels(), filter.getAggrLevels())) continue;
                    IDiskArray levelKeyList = this.populateLevelKeyList(aggregations[i], resultSet[i], filter);
                    IDiskArray selectedLevelKeys = null;
                    if (levelFilterMap.containsKey(filter.getTargetLevel())) {
                        Object[] valueObjs = (Object[])levelFilterMap.get(filter.getTargetLevel());
                        selectedLevelKeys = (IDiskArray)valueObjs[0];
                        selectedLevelKeys = SetUtil.getIntersection(selectedLevelKeys, levelKeyList);
                    } else {
                        selectedLevelKeys = levelKeyList;
                    }
                    levelFilterMap.put(filter.getTargetLevel(), new Object[]{selectedLevelKeys, filter.getFilterHelper()});
                }
                for (DimLevel target : levelFilterMap.keySet()) {
                    Object[] valueObjs = (Object[])levelFilterMap.get(target);
                    IDiskArray selectedKeyArray = (IDiskArray)valueObjs[0];
                    IJSFilterHelper filterHelper = (IJSFilterHelper)valueObjs[1];
                    if (selectedKeyArray.size() == 0) continue;
                    ILevel[] levels = this.getLevelsOfDimension(target.getDimensionName());
                    int index = FilterUtil.getTargetLevelIndex(levels, target.getLevelName());
                    HashMap<String, ArrayList<MultiKey>> keyMap = new HashMap<String, ArrayList<MultiKey>>();
                    int k = 0;
                    while (k < selectedKeyArray.size()) {
                        MultiKey multiKey = (MultiKey)selectedKeyArray.get(k);
                        String parentKey = this.getParentKey(multiKey.dimMembers, index);
                        ArrayList<MultiKey> keyList = (ArrayList<MultiKey>)keyMap.get(parentKey);
                        if (keyList == null) {
                            keyList = new ArrayList<MultiKey>();
                            keyMap.put(parentKey, keyList);
                        }
                        keyList.add(multiKey);
                        ++k;
                    }
                    for (List keyList : keyMap.values()) {
                        ISelection selections = this.toMultiKeySelection(keyList);
                        LevelFilter levelFilter = new LevelFilter(target, new ISelection[]{selections});
                        levelFilter.setDimMembers(((MultiKey)keyList.get((int)0)).dimMembers);
                        levelFilter.setFilterHelper(filterHelper);
                        levelFilterList.add(levelFilter);
                    }
                }
            }
            ++i;
        }
    }

    private ILevel[] getLevelsOfDimension(String dimensionName) {
        return (ILevel[])this.dimensionMap.get(dimensionName);
    }

    private IDiskArray populateLevelKeyList(AggregationDefinition aggregation, IAggregationResultSet resultSet, TopBottomFilterDefinition filter) throws DataException {
        IJSTopBottomFilterHelper filterHelper = (IJSTopBottomFilterHelper)filter.getFilterHelper();
        int n = -1;
        if (!filterHelper.isPercent()) {
            n = (int)filterHelper.getN();
        }
        OrderedDiskArray aggrValueArray = new OrderedDiskArray(n, filterHelper.isTop());
        String dimensionName = filter.getTargetLevel().getDimensionName();
        try {
            AggregationRowAccessor row4filter = new AggregationRowAccessor(resultSet, this.fetcher);
            int k = 0;
            while (k < resultSet.length()) {
                resultSet.seek(k);
                int levelIndex = resultSet.getLevelIndex(filter.getTargetLevel());
                Object[] levelKey = resultSet.getLevelKeyValue(levelIndex);
                if (levelKey != null && filterHelper.isQualifiedRow(row4filter)) {
                    Object aggrValue = filterHelper.evaluateFilterExpr(row4filter);
                    Member[] members = this.getTargetDimMembers(dimensionName, resultSet);
                    aggrValueArray.add(new ValueObject(aggrValue, new MultiKey(levelKey, members)));
                }
                ++k;
            }
            return this.fetchLevelKeys(aggrValueArray, filterHelper);
        }
        catch (IOException e) {
            throw new DataException("", e);
        }
    }

    private IDiskArray fetchLevelKeys(IDiskArray aggrValueArray, IJSTopBottomFilterHelper filterHelper) throws IOException {
        int start = 0;
        int end = aggrValueArray.size();
        if (filterHelper.isPercent()) {
            int size = aggrValueArray.size();
            int n = FilterUtil.getTargetN(size, filterHelper.getN());
            if (filterHelper.isTop()) {
                start = size - n;
            } else {
                end = n;
            }
        }
        BufferedPrimitiveDiskArray levelKeyArray = new BufferedPrimitiveDiskArray(Math.min(end - start + 1, Constants.LIST_BUFFER_SIZE));
        int i = start;
        while (i < end) {
            ValueObject aggrValue = (ValueObject)aggrValueArray.get(i);
            levelKeyArray.add(aggrValue.index);
            ++i;
        }
        return levelKeyArray;
    }

    private String getParentKey(Member[] members, int index) {
        assert (index >= 0 && index < members.length);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < index) {
            if (members[i] == null) {
                buf.append('?');
            } else {
                Object[] keyValues = members[i].getKeyValues();
                if (keyValues != null && keyValues.length > 0) {
                    int j = 0;
                    while (j < keyValues.length) {
                        buf.append(keyValues[j].toString());
                        buf.append(',');
                        ++j;
                    }
                    buf.deleteCharAt(buf.length() - 1);
                }
            }
            buf.append('-');
            ++i;
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    private ISelection toMultiKeySelection(List keyList) {
        Object[][] keys = new Object[keyList.size()][];
        int i = 0;
        while (i < keyList.size()) {
            MultiKey multiKey = (MultiKey)keyList.get(i);
            keys[i] = multiKey.values;
            ++i;
        }
        return SelectionFactory.createMutiKeySelection(keys);
    }
}

