/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.IRDAggrUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.stream.WrapperedRAInputStream;

public class RDAggrUtil
implements IRDAggrUtil {
    private HashMap<String, RDAggrValueHolder> holders = new HashMap();
    private IBaseQueryDefinition qd;
    private RAInputStream aggrIndexStream;
    private DataInputStream valueStream;

    public RDAggrUtil(StreamManager manager, IBaseQueryDefinition qd) throws DataException {
        this.qd = qd;
        try {
            this.aggrIndexStream = manager.getInStream(103, 0, 2);
            int aggrSize = IOUtil.readInt(this.aggrIndexStream);
            DataInputStream aggrIndexDis = new DataInputStream(this.aggrIndexStream);
            this.valueStream = new DataInputStream(new WrapperedRAInputStream(manager.getInStream(104, 0, 2), 0L, -1L));
            int i = 0;
            while (i < aggrSize) {
                RDAggrValueHolder holder = new RDAggrValueHolder(this.valueStream);
                this.holders.put(holder.getName(), holder);
                if (i < aggrSize - 1) {
                    long offset = IOUtil.readLong(aggrIndexDis);
                    this.valueStream = manager.getVersion() >= 140 ? new DataInputStream(new WrapperedRAInputStream(manager.getInStream(104, 0, 2), offset, -1L)) : new DataInputStream(new WrapperedRAInputStream(manager.getInStream(104, 0, 2), offset + 1L, -1L));
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public boolean contains(String aggrName) {
        return this.holders.containsKey(aggrName);
    }

    public int getGroupLevel(String aggrName) {
        if (this.contains(aggrName)) {
            return this.holders.get(aggrName).getGroupLevel();
        }
        return -1;
    }

    public boolean isRunningAggr(String aggrName) {
        if (this.contains(aggrName)) {
            return this.holders.get(aggrName).isRunningAggr();
        }
        return false;
    }

    public Object getValue(String aggrName, int groupInstanceIndex) throws DataException {
        try {
            if (this.contains(aggrName)) {
                Object value = this.holders.get(aggrName).get(groupInstanceIndex);
                if (value != null && value instanceof BirtException) {
                    throw (BirtException)value;
                }
                if (this.qd != null && this.qd.getBindings().containsKey(aggrName)) {
                    IBinding b = (IBinding)this.qd.getBindings().get(aggrName);
                    value = DataTypeUtil.convert(value, b.getDataType());
                }
                return value;
            }
            return null;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        catch (BirtException e) {
            if (e instanceof DataException) {
                throw new DataException(e.getErrorCode(), ((DataException)e).getArgument());
            }
            throw new DataException(e.getErrorCode(), e);
        }
    }

    public void close() throws DataException {
        try {
            if (!this.holders.isEmpty()) {
                Collection<RDAggrValueHolder> values = this.holders.values();
                Iterator<RDAggrValueHolder> iter = values.iterator();
                while (iter.hasNext()) {
                    iter.next().close();
                }
            }
            if (this.aggrIndexStream != null) {
                this.aggrIndexStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static class RDAggrValueHolder {
        private int groupInstanceIndex = 0;
        private int size = 0;
        private int groupLevel;
        private DataInputStream valueStream;
        private boolean isRunningAggr;
        private String bindingName;
        private Object currentValue;

        public RDAggrValueHolder(DataInputStream valueStream) throws IOException, DataException {
            this.bindingName = IOUtil.readString(valueStream);
            this.populateRunningAggrInfo(valueStream);
            this.groupLevel = IOUtil.readInt(valueStream);
            this.size = IOUtil.readInt(valueStream);
            this.valueStream = valueStream;
            if (this.size > 0) {
                this.currentValue = IOUtil.readObject(valueStream, DataEngineSession.getCurrentClassLoader());
            }
        }

        private void populateRunningAggrInfo(DataInputStream valueStream) throws IOException, DataException {
            String aggrName = IOUtil.readString(valueStream);
            if (AggregationManager.getInstance().getAggregation(aggrName) == null) {
                throw new DataException("data.engine.InvalidAggregation", aggrName);
            }
            this.isRunningAggr = AggregationManager.getInstance().getAggregation(aggrName).getType() == 1;
        }

        public String getName() {
            return this.bindingName;
        }

        public boolean isRunningAggr() {
            return this.isRunningAggr;
        }

        public int getGroupLevel() {
            return this.groupLevel;
        }

        /*
         * Unable to fully structure code
         */
        public Object get(int index) throws IOException {
            if (index == this.groupInstanceIndex) {
                return this.currentValue;
            }
            if (index >= this.groupInstanceIndex && index < this.size) ** GOTO lbl7
            return null;
lbl-1000:
            // 1 sources

            {
                this.currentValue = IOUtil.readObject(this.valueStream, DataEngineSession.getCurrentClassLoader());
                ++this.groupInstanceIndex;
lbl7:
                // 2 sources

                ** while (this.groupInstanceIndex < index)
            }
lbl8:
            // 1 sources

            return this.currentValue;
        }

        public void close() throws IOException {
            if (this.valueStream != null) {
                this.valueStream.close();
            }
        }
    }
}

