/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Anchor implements Enumerator
{
    NORTH_LITERAL(0, "North", "North"),
    NORTH_EAST_LITERAL(1, "NorthEast", "North_East"),
    EAST_LITERAL(2, "East", "East"),
    SOUTH_EAST_LITERAL(3, "SouthEast", "South_East"),
    SOUTH_LITERAL(4, "South", "South"),
    SOUTH_WEST_LITERAL(5, "SouthWest", "South_West"),
    WEST_LITERAL(6, "West", "West"),
    NORTH_WEST_LITERAL(7, "NorthWest", "North_West");

    public static final int NORTH = 0;
    public static final int NORTH_EAST = 1;
    public static final int EAST = 2;
    public static final int SOUTH_EAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTH_WEST = 5;
    public static final int WEST = 6;
    public static final int NORTH_WEST = 7;
    private static final Anchor[] VALUES_ARRAY;
    public static final List<Anchor> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Anchor[]{NORTH_LITERAL, NORTH_EAST_LITERAL, EAST_LITERAL, SOUTH_EAST_LITERAL, SOUTH_LITERAL, SOUTH_WEST_LITERAL, WEST_LITERAL, NORTH_WEST_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Anchor get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Anchor result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Anchor getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Anchor result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Anchor get(int value) {
        switch (value) {
            case 0: {
                return NORTH_LITERAL;
            }
            case 1: {
                return NORTH_EAST_LITERAL;
            }
            case 2: {
                return EAST_LITERAL;
            }
            case 3: {
                return SOUTH_EAST_LITERAL;
            }
            case 4: {
                return SOUTH_LITERAL;
            }
            case 5: {
                return SOUTH_WEST_LITERAL;
            }
            case 6: {
                return WEST_LITERAL;
            }
            case 7: {
                return NORTH_WEST_LITERAL;
            }
        }
        return null;
    }

    private Anchor(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

