/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workflow.core.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.impl.NodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Split
extends NodeImpl {
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_AND = 1;
    public static final int TYPE_XOR = 2;
    public static final int TYPE_OR = 3;
    private static final long serialVersionUID = 400L;
    private int type;
    private Map<ConnectionRef, Constraint> constraints = new HashMap<ConnectionRef, Constraint>();

    public Split() {
        this.type = 0;
    }

    public Split(int type) {
        this.type = type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Constraint getConstraint(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.type == 3 || this.type == 2) {
            ConnectionRef ref = new ConnectionRef(connection.getTo().getId(), connection.getToType());
            return this.constraints.get(ref);
        }
        throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with: " + this.getType());
    }

    public Constraint internalGetConstraint(ConnectionRef ref) {
        return this.constraints.get(ref);
    }

    public void setConstraint(Connection connection, Constraint constraint) {
        if (this.type == 3 || this.type == 2) {
            if (connection == null) {
                throw new IllegalArgumentException("connection is null");
            }
            if (this.getOutgoingConnections("DROOLS_DEFAULT") != null && !this.getOutgoingConnections("DROOLS_DEFAULT").contains(connection)) {
                throw new IllegalArgumentException("connection is unknown:" + connection);
            }
        } else {
            throw new UnsupportedOperationException("Constraints are only supported with XOR or OR split types, not with type:" + this.getType());
        }
        this.internalSetConstraint(new ConnectionRef(connection.getTo().getId(), connection.getToType()), constraint);
    }

    public void internalSetConstraint(ConnectionRef connectionRef, Constraint constraint) {
        this.constraints.put(connectionRef, constraint);
    }

    public Map<ConnectionRef, Constraint> getConstraints() {
        return Collections.unmodifiableMap(this.constraints);
    }

    public Connection getFrom() {
        List<Connection> list = this.getIncomingConnections("DROOLS_DEFAULT");
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<Connection> getDefaultOutgoingConnections() {
        return this.getOutgoingConnections("DROOLS_DEFAULT");
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default incoming connection type!");
        }
        if (!this.getIncomingConnections("DROOLS_DEFAULT").isEmpty()) {
            throw new IllegalArgumentException("This type of node cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default outgoing connection type!");
        }
    }

    @Override
    public void removeOutgoingConnection(String type, Connection connection) {
        super.removeOutgoingConnection(type, connection);
        this.removeConstraint(connection);
    }

    public void removeConstraint(Connection connection) {
        ConnectionRef ref = new ConnectionRef(connection.getTo().getId(), connection.getToType());
        this.internalRemoveConstraint(ref);
    }

    public void internalRemoveConstraint(ConnectionRef ref) {
        this.constraints.remove(ref);
    }

    public static class ConnectionRef
    implements Serializable {
        private static final long serialVersionUID = 4L;
        private String toType;
        private long nodeId;

        public ConnectionRef(long nodeId, String toType) {
            this.nodeId = nodeId;
            this.toType = toType;
        }

        public String getToType() {
            return this.toType;
        }

        public long getNodeId() {
            return this.nodeId;
        }

        public boolean equals(Object o) {
            if (o instanceof ConnectionRef) {
                ConnectionRef c = (ConnectionRef)o;
                return this.toType.equals(c.toType) && this.nodeId == c.nodeId;
            }
            return false;
        }

        public int hashCode() {
            return 7 * this.toType.hashCode() + (int)this.nodeId;
        }
    }
}

