/*
 * Decompiled with CFR 0.152.
 */
package org.drools.concurrent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.concurrent.Command;
import org.drools.concurrent.CommandExecutor;
import org.drools.concurrent.ExecutorService;
import org.drools.concurrent.Future;

public class DefaultExecutorService
implements ExecutorService {
    private static final long serialVersionUID = 7860812696865293690L;
    private Thread thread;
    private CommandExecutor executor;
    private boolean running;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.thread = (Thread)in.readObject();
        this.executor = (CommandExecutor)in.readObject();
        this.running = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.thread);
        out.writeObject(this.executor);
        out.writeBoolean(this.running);
    }

    public void setCommandExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    public void startUp() {
        this.thread = new Thread(this.executor);
        this.thread.start();
        this.running = true;
    }

    public void shutDown() {
        this.executor.shutdown();
        this.running = false;
        this.thread = null;
    }

    public Future submit(Command command) {
        if (!this.running) {
            this.startUp();
        }
        return this.executor.submit(command);
    }
}

