/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.distribution;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class UniformDistribution
extends Distribution {
    private double upper;
    private double lower;

    @JsonCreator
    public UniformDistribution(@JsonProperty(value="lower") double lower, @JsonProperty(value="upper") double upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, (Number)upper, false);
        }
        this.lower = lower;
        this.upper = upper;
    }

    public String toString() {
        return "UniformDistribution(lower=" + this.lower + ", upper=" + this.upper + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniformDistribution)) {
            return false;
        }
        UniformDistribution other = (UniformDistribution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getUpper(), other.getUpper()) != 0) {
            return false;
        }
        return Double.compare(this.getLower(), other.getLower()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniformDistribution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $upper = Double.doubleToLongBits(this.getUpper());
        result = result * 59 + (int)($upper >>> 32 ^ $upper);
        long $lower = Double.doubleToLongBits(this.getLower());
        result = result * 59 + (int)($lower >>> 32 ^ $lower);
        return result;
    }

    public double getUpper() {
        return this.upper;
    }

    public double getLower() {
        return this.lower;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }
}

