/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacv.FrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"converter", "currentImage"})
public abstract class BaseImageTransform<F>
implements ImageTransform {
    protected Random random;
    protected FrameConverter<F> converter;
    protected ImageWritable currentImage;

    protected BaseImageTransform(Random random) {
        this.random = random;
    }

    public final ImageWritable transform(ImageWritable image) {
        return this.transform(image, this.random);
    }

    @Override
    public final ImageWritable transform(ImageWritable image, Random random) {
        this.currentImage = this.doTransform(image, random);
        return this.currentImage;
    }

    protected abstract ImageWritable doTransform(ImageWritable var1, Random var2);

    @Override
    public float[] query(float ... coordinates) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImageWritable getCurrentImage() {
        return this.currentImage;
    }

    public BaseImageTransform() {
    }

    public Random getRandom() {
        return this.random;
    }

    public FrameConverter<F> getConverter() {
        return this.converter;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setConverter(FrameConverter<F> converter) {
        this.converter = converter;
    }

    public void setCurrentImage(ImageWritable currentImage) {
        this.currentImage = currentImage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseImageTransform)) {
            return false;
        }
        BaseImageTransform other = (BaseImageTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Random this$random = this.getRandom();
        Random other$random = other.getRandom();
        if (this$random == null ? other$random != null : !this$random.equals(other$random)) {
            return false;
        }
        FrameConverter<F> this$converter = this.getConverter();
        FrameConverter<F> other$converter = other.getConverter();
        if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
            return false;
        }
        ImageWritable this$currentImage = this.getCurrentImage();
        ImageWritable other$currentImage = other.getCurrentImage();
        return !(this$currentImage == null ? other$currentImage != null : !((Object)this$currentImage).equals(other$currentImage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseImageTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Random $random = this.getRandom();
        result = result * 59 + ($random == null ? 43 : $random.hashCode());
        FrameConverter<F> $converter = this.getConverter();
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        ImageWritable $currentImage = this.getCurrentImage();
        result = result * 59 + ($currentImage == null ? 43 : $currentImage.hashCode());
        return result;
    }

    public String toString() {
        return "BaseImageTransform(random=" + this.getRandom() + ", converter=" + this.getConverter() + ", currentImage=" + this.getCurrentImage() + ")";
    }
}

