/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ImplementationCreator;
import org.datanucleus.enhancer.AbstractImplementationGenerator;
import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.EnhancerClassLoader;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public abstract class AbstractImplementationCreator
implements ImplementationCreator {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected final MetaDataManager metaDataMgr;
    protected final EnhancerClassLoader loader;

    public AbstractImplementationCreator(MetaDataManager mmgr) {
        this.metaDataMgr = mmgr;
        this.loader = new EnhancerClassLoader();
    }

    public Object newInstance(Class cls, ClassLoaderResolver clr) {
        try {
            if (PersistenceCapable.class.isAssignableFrom(cls)) {
                if (Modifier.isAbstract(cls.getModifiers())) {
                    ClassMetaData cmd = (ClassMetaData)this.metaDataMgr.getMetaDataForClass(cls, clr);
                    if (cmd == null) {
                        throw new JDOFatalException("Could not find metadata for class " + cls.getName());
                    }
                    PersistenceCapable obj = this.newInstance(cmd, clr);
                    if (!this.metaDataMgr.hasMetaDataForClass(obj.getClass().getName())) {
                        this.metaDataMgr.registerImplementationOfAbstractClass(cmd, obj.getClass(), clr);
                    }
                    if (obj == null) {
                        throw new JDOFatalException(LOCALISER.msg("ImplementationCreator.InstanceCreateFailed", (Object)cls.getName()));
                    }
                    return obj;
                }
                return cls.newInstance();
            }
            InterfaceMetaData imd = this.metaDataMgr.getMetaDataForInterface(cls, clr);
            if (imd == null) {
                throw new JDOFatalException("Could not find metadata for class/interface " + cls.getName());
            }
            PersistenceCapable obj = this.newInstance(imd, clr);
            if (!this.metaDataMgr.hasMetaDataForClass(obj.getClass().getName())) {
                this.metaDataMgr.registerPersistentInterface(imd, obj.getClass(), clr);
            }
            if (obj == null) {
                throw new JDOFatalException(LOCALISER.msg("ImplementationCreator.InstanceCreateFailed", (Object)cls.getName()));
            }
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new JDOUserException(e.toString(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new JDOUserException(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JDOUserException(e.toString(), (Throwable)e);
        }
    }

    protected PersistenceCapable newInstance(InterfaceMetaData imd, ClassLoaderResolver clr) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = clr.classForName(imd.getFullClassName());
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("jdo")) continue;
            String propertyName = methodName;
            if (methodName.startsWith("set")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanSetter((String)methodName);
            } else if (methodName.startsWith("get")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanGetter((String)methodName);
            }
            if (imd.getMetaDataForMember(propertyName) != null) continue;
            throw new NucleusUserException(LOCALISER.msg("ImplementationCreator.InterfaceMethodUndefined", (Object)imd.getFullClassName(), (Object)methodName));
        }
        String implClassName = imd.getName() + "Impl";
        String implFullClassName = imd.getPackageName() + '.' + implClassName;
        try {
            this.loader.loadClass(implFullClassName);
        }
        catch (ClassNotFoundException e) {
            AbstractImplementationGenerator gen = this.getGenerator((AbstractClassMetaData)imd, implClassName);
            gen.enhance(clr);
            this.loader.defineClass(implFullClassName, gen.getBytes(), clr);
        }
        Object instance = this.loader.loadClass(implFullClassName).newInstance();
        if (instance instanceof PersistenceCapable) {
            return (PersistenceCapable)instance;
        }
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        String implementedInterfacesMsg = "[";
        String classLoaderPCMsg = "";
        for (int i = 0; i < interfaces.length; ++i) {
            implementedInterfacesMsg = implementedInterfacesMsg + interfaces[i].getName();
            if (i < interfaces.length - 1) {
                implementedInterfacesMsg = implementedInterfacesMsg + ",";
            }
            if (!interfaces[i].getName().equals(PersistenceCapable.class.getName())) continue;
            classLoaderPCMsg = LOCALISER.msg("ImplementationCreator.DifferentClassLoader", (Object)interfaces[i].getClassLoader(), (Object)PersistenceCapable.class.getClassLoader());
        }
        implementedInterfacesMsg = implementedInterfacesMsg + "]";
        throw new JDOException(LOCALISER.msg("ImplementationCreator.NotPCProblem", (Object)implFullClassName, (Object)classLoaderPCMsg, (Object)implementedInterfacesMsg));
    }

    protected PersistenceCapable newInstance(ClassMetaData cmd, ClassLoaderResolver clr) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls = clr.classForName(cmd.getFullClassName());
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!Modifier.isAbstract(methods[i].getModifiers()) || methodName.startsWith("jdo")) continue;
            String propertyName = methodName;
            if (methodName.startsWith("set")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanSetter((String)methodName);
            } else if (methodName.startsWith("get")) {
                propertyName = ClassUtils.getFieldNameForJavaBeanGetter((String)methodName);
            }
            if (cmd.getMetaDataForMember(propertyName) != null) continue;
            throw new NucleusUserException(LOCALISER.msg("ImplementationCreator.AbstractClassMethodUndefined", (Object)cmd.getFullClassName(), (Object)methodName));
        }
        String implClassName = cmd.getName() + "Impl";
        String implFullClassName = cmd.getPackageName() + '.' + implClassName;
        try {
            this.loader.loadClass(implFullClassName);
        }
        catch (ClassNotFoundException e) {
            AbstractImplementationGenerator gen = this.getGenerator((AbstractClassMetaData)cmd, implClassName);
            gen.enhance(clr);
            this.loader.defineClass(implFullClassName, gen.getBytes(), clr);
        }
        Object instance = this.loader.loadClass(implFullClassName).newInstance();
        if (instance instanceof PersistenceCapable) {
            return (PersistenceCapable)instance;
        }
        Class<?>[] interfaces = instance.getClass().getInterfaces();
        String implementedInterfacesMsg = "[";
        String classLoaderPCMsg = "";
        for (int i = 0; i < interfaces.length; ++i) {
            implementedInterfacesMsg = implementedInterfacesMsg + interfaces[i].getName();
            if (i < interfaces.length - 1) {
                implementedInterfacesMsg = implementedInterfacesMsg + ",";
            }
            if (!interfaces[i].getName().equals(PersistenceCapable.class.getName())) continue;
            classLoaderPCMsg = LOCALISER.msg("ImplementationCreator.DifferentClassLoader", (Object)interfaces[i].getClassLoader(), (Object)PersistenceCapable.class.getClassLoader());
        }
        implementedInterfacesMsg = implementedInterfacesMsg + "]";
        throw new JDOException(LOCALISER.msg("ImplementationCreator.NotPCProblem", (Object)implFullClassName, (Object)classLoaderPCMsg, (Object)implementedInterfacesMsg));
    }

    protected abstract AbstractImplementationGenerator getGenerator(AbstractClassMetaData var1, String var2);

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

