/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import java.util.Objects;

public class Hash {
    private String algorithm;
    private String value;

    public Hash() {
    }

    public Hash(Algorithm algorithm, String value) {
        this.algorithm = algorithm.getSpec();
        this.value = value;
    }

    public Hash(String algorithm, String value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hash hash = (Hash)o;
        return Objects.equals(this.algorithm, hash.algorithm) && Objects.equals(this.value, hash.value);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.value);
    }

    public static enum Algorithm {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA_256("SHA-256"),
        SHA_384("SHA-384"),
        SHA_512("SHA-512"),
        SHA3_256("SHA3-256"),
        SHA3_512("SHA3-512");

        private String spec;

        private Algorithm(String spec) {
            this.spec = spec;
        }

        public String getSpec() {
            return this.spec;
        }
    }
}

