/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.enums.EnumToStringConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.converters.HashConverter;
import org.cyclonedx.converters.LicenseTextConverter;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Commit;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.ext.dependencyGraph.Dependency;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BomParser
extends CycloneDxSchema {
    public Bom parse(File file) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(this.extractAllNamespaceDeclarations(new InputSource(new FileInputStream(file))));
            XStream xstream = this.mapDefaultObjectModel(this.createXStream());
            Bom bom = (Bom)xstream.fromXML(file);
            return this.injectSchemaVersion(bom, schemaVersion);
        }
        catch (XStreamException | FileNotFoundException | XPathExpressionException e) {
            throw new ParseException(e);
        }
    }

    public Bom parse(byte[] bomBytes) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(this.extractAllNamespaceDeclarations(new InputSource(new ByteArrayInputStream(bomBytes))));
            XStream xstream = this.mapDefaultObjectModel(this.createXStream());
            Bom bom = (Bom)xstream.fromXML((InputStream)new ByteArrayInputStream(bomBytes));
            return this.injectSchemaVersion(bom, schemaVersion);
        }
        catch (XStreamException | XPathExpressionException e) {
            throw new ParseException(e);
        }
    }

    public Bom parse(URL url) throws ParseException {
        try {
            String schemaVersion = this.identifySchemaVersion(this.extractAllNamespaceDeclarations(new InputSource(url.openStream())));
            XStream xstream = this.mapDefaultObjectModel(this.createXStream());
            Bom bom = (Bom)xstream.fromXML(url);
            return this.injectSchemaVersion(bom, schemaVersion);
        }
        catch (XStreamException | IOException | XPathExpressionException e) {
            throw new ParseException(e);
        }
    }

    public Bom parse(Reader reader) throws ParseException {
        try {
            XStream xstream = this.mapDefaultObjectModel(this.createXStream());
            return (Bom)xstream.fromXML(reader);
        }
        catch (XStreamException e) {
            throw new ParseException(e);
        }
    }

    private Bom injectSchemaVersion(Bom bom, String schemaVersion) {
        try {
            Field field = Bom.class.getDeclaredField("schemaVersion");
            field.setAccessible(true);
            field.set(bom, schemaVersion);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return bom;
    }

    public List<SAXParseException> validate(File file) throws IOException, SAXException {
        return this.validate(file, CycloneDxSchema.Version.VERSION_11);
    }

    public List<SAXParseException> validate(File file, CycloneDxSchema.Version schemaVersion) throws IOException, SAXException {
        StreamSource xmlFile = new StreamSource(file);
        final LinkedList<SAXParseException> exceptions = new LinkedList<SAXParseException>();
        Schema schema = this.getXmlSchema(schemaVersion);
        Validator validator = schema.newValidator();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                exceptions.add(exception);
            }

            @Override
            public void fatalError(SAXParseException exception) {
                exceptions.add(exception);
            }

            @Override
            public void error(SAXParseException exception) {
                exceptions.add(exception);
            }
        });
        validator.validate(xmlFile);
        return exceptions;
    }

    public boolean isValid(File file) throws IOException, SAXException {
        return this.validate(file).isEmpty();
    }

    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion) throws IOException, SAXException {
        return this.validate(file, schemaVersion).isEmpty();
    }

    private String identifySchemaVersion(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            for (CycloneDxSchema.Version version : CycloneDxSchema.Version.values()) {
                if (!version.getNamespace().equals(node.getNodeValue())) continue;
                return version.getVersionString();
            }
        }
        return null;
    }

    private NodeList extractAllNamespaceDeclarations(InputSource in) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile("//namespace::*");
        NodeList nodeList = (NodeList)xPathExpression.evaluate(in, XPathConstants.NODESET);
        return nodeList;
    }

    private Map<String, Component.Type> getComponentTypeMapping() {
        HashMap<String, Component.Type> map = new HashMap<String, Component.Type>();
        map.put(Component.Type.APPLICATION.getTypeName(), Component.Type.APPLICATION);
        map.put(Component.Type.FRAMEWORK.getTypeName(), Component.Type.FRAMEWORK);
        map.put(Component.Type.LIBRARY.getTypeName(), Component.Type.LIBRARY);
        map.put(Component.Type.OPERATING_SYSTEM.getTypeName(), Component.Type.OPERATING_SYSTEM);
        map.put(Component.Type.DEVICE.getTypeName(), Component.Type.DEVICE);
        map.put(Component.Type.FILE.getTypeName(), Component.Type.FILE);
        return map;
    }

    private Map<String, Component.Scope> getComponentScopeMapping() {
        HashMap<String, Component.Scope> map = new HashMap<String, Component.Scope>();
        map.put(Component.Scope.REQUIRED.getScopeName(), Component.Scope.REQUIRED);
        map.put(Component.Scope.EXCLUDED.getScopeName(), Component.Scope.EXCLUDED);
        map.put(Component.Scope.OPTIONAL.getScopeName(), Component.Scope.OPTIONAL);
        return map;
    }

    private Map<String, ExternalReference.Type> getExternalReferenceTypeMapping() {
        HashMap<String, ExternalReference.Type> map = new HashMap<String, ExternalReference.Type>();
        map.put(ExternalReference.Type.VCS.getTypeName(), ExternalReference.Type.VCS);
        map.put(ExternalReference.Type.ISSUE_TRACKER.getTypeName(), ExternalReference.Type.ISSUE_TRACKER);
        map.put(ExternalReference.Type.WEBSITE.getTypeName(), ExternalReference.Type.WEBSITE);
        map.put(ExternalReference.Type.ADVISORIES.getTypeName(), ExternalReference.Type.ADVISORIES);
        map.put(ExternalReference.Type.BOM.getTypeName(), ExternalReference.Type.BOM);
        map.put(ExternalReference.Type.MAILING_LIST.getTypeName(), ExternalReference.Type.MAILING_LIST);
        map.put(ExternalReference.Type.SOCIAL.getTypeName(), ExternalReference.Type.SOCIAL);
        map.put(ExternalReference.Type.CHAT.getTypeName(), ExternalReference.Type.CHAT);
        map.put(ExternalReference.Type.DOCUMENTATION.getTypeName(), ExternalReference.Type.DOCUMENTATION);
        map.put(ExternalReference.Type.SUPPORT.getTypeName(), ExternalReference.Type.SUPPORT);
        map.put(ExternalReference.Type.DISTRIBUTION.getTypeName(), ExternalReference.Type.DISTRIBUTION);
        map.put(ExternalReference.Type.LICENSE.getTypeName(), ExternalReference.Type.LICENSE);
        map.put(ExternalReference.Type.BUILD_META.getTypeName(), ExternalReference.Type.BUILD_META);
        map.put(ExternalReference.Type.BUILD_SYSTEM.getTypeName(), ExternalReference.Type.BUILD_SYSTEM);
        map.put(ExternalReference.Type.OTHER.getTypeName(), ExternalReference.Type.OTHER);
        return map;
    }

    private XStream createXStream() {
        QName qname = new QName("http://cyclonedx.org/schema/bom/1.1");
        QNameMap nsm = new QNameMap();
        nsm.registerMapping(qname, Bom.class);
        nsm.setDefaultNamespace("http://cyclonedx.org/schema/bom/1.1");
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver(nsm)){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        try {
                            return definedIn != Object.class || this.realClass(fieldName) != null;
                        }
                        catch (CannotResolveClassException e) {
                            return false;
                        }
                    }

                    public Class realClass(String elementName) {
                        try {
                            return super.realClass(elementName);
                        }
                        catch (CannotResolveClassException e) {
                            return null;
                        }
                    }
                };
            }
        };
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.allowTypesByWildcard(new String[]{"org.cyclonedx.model.**", "org.cyclonedx.model.ext.dependencyGraph.**"});
        return xstream;
    }

    private XStream mapDefaultObjectModel(XStream xstream) {
        xstream.alias("bom", Bom.class);
        xstream.aliasAttribute(Bom.class, "version", "version");
        xstream.aliasAttribute(Bom.class, "serialNumber", "serialNumber");
        xstream.alias("component", Component.class);
        xstream.aliasAttribute(Component.class, "type", "type");
        xstream.aliasAttribute(Component.class, "bomRef", "bom-ref");
        xstream.aliasAttribute(Component.class, "scope", "scope");
        xstream.registerConverter((SingleValueConverter)new EnumToStringConverter(Component.Type.class, this.getComponentTypeMapping()));
        xstream.registerConverter((SingleValueConverter)new EnumToStringConverter(Component.Scope.class, this.getComponentScopeMapping()));
        xstream.alias("hash", Hash.class);
        xstream.registerConverter((Converter)new HashConverter());
        xstream.alias("commit", Commit.class);
        xstream.alias("reference", ExternalReference.class);
        xstream.aliasAttribute(ExternalReference.class, "type", "type");
        xstream.registerConverter((SingleValueConverter)new EnumToStringConverter(ExternalReference.Type.class, this.getExternalReferenceTypeMapping()));
        xstream.aliasField("licenses", Component.class, "licenseChoice");
        xstream.alias("license", License.class);
        xstream.addImplicitCollection(LicenseChoice.class, "licenses");
        xstream.registerConverter((Converter)new LicenseTextConverter());
        xstream.aliasField("text", License.class, "licenseText");
        xstream.alias("pedigree", Pedigree.class);
        xstream.addImplicitCollection(Dependency.class, "dependencies");
        xstream.alias("dependency", Dependency.class);
        xstream.aliasAttribute(Dependency.class, "ref", "ref");
        return xstream;
    }
}

