/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.util;

import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.sonar.report.pdf.entity.exception.ReportException;
import org.sonar.report.pdf.util.Logger;

public class SonarAccess {
    private String sonarUrl;
    private String username;
    private String password;
    private String host;
    private int port;

    public SonarAccess(String sonarUrl, String username, String password) throws ReportException {
        this.sonarUrl = !sonarUrl.endsWith("/") ? sonarUrl : sonarUrl.substring(0, sonarUrl.length() - 1);
        this.username = username;
        this.password = password;
        if (sonarUrl.startsWith("http://")) {
            String withoutProtocol = sonarUrl.substring(7);
            this.host = withoutProtocol.contains(":") ? withoutProtocol.substring(0, withoutProtocol.indexOf(58)) : (withoutProtocol.contains("/") ? withoutProtocol.substring(0, withoutProtocol.indexOf(47)) : withoutProtocol);
            this.port = withoutProtocol.contains(":") ? (withoutProtocol.contains("/") ? Integer.valueOf(withoutProtocol.substring(withoutProtocol.indexOf(58) + 1, withoutProtocol.indexOf(47))).intValue() : Integer.valueOf(withoutProtocol.substring(withoutProtocol.indexOf(58) + 1)).intValue()) : 80;
        } else if (sonarUrl.startsWith("https://")) {
            String withoutProtocol = sonarUrl.substring(8);
            this.host = withoutProtocol.contains(":") ? withoutProtocol.substring(0, withoutProtocol.indexOf(58)) : (withoutProtocol.contains("/") ? withoutProtocol.substring(0, withoutProtocol.indexOf(47)) : withoutProtocol);
            this.port = withoutProtocol.contains(":") ? (withoutProtocol.contains("/") ? Integer.valueOf(withoutProtocol.substring(withoutProtocol.indexOf(58) + 1, withoutProtocol.indexOf(47))).intValue() : Integer.valueOf(withoutProtocol.substring(withoutProtocol.indexOf(58) + 1)).intValue()) : 443;
        } else {
            throw new ReportException("Unknown URL format: " + sonarUrl + " (forgot http:// before host?)");
        }
    }

    public Document getUrlAsDocument(String urlPath) throws HttpException, IOException, DocumentException {
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(this.sonarUrl + urlPath);
        int status = 0;
        Logger.debug("HTTP Request: " + this.sonarUrl + urlPath);
        if (this.username != null) {
            Logger.debug("Setting authentication with username: " + this.username);
            client.getParams().setAuthenticationPreemptive(true);
            client.getState().setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            method.setDoAuthentication(true);
        }
        if ((status = client.executeMethod((HttpMethod)method)) != 200) {
            Logger.error("Can\u00b4t access to Sonar or project doesn't exist on Sonar instance. HTTP KO to " + this.sonarUrl + urlPath);
            throw new IOException("Can\u00b4t access to Sonar or project doesn't exist on Sonar instance.");
        }
        Logger.debug("Received response.");
        SAXReader reader = new SAXReader();
        return reader.read(method.getResponseBodyAsStream());
    }

    public String getSonarUrl() {
        return this.sonarUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

