/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Style {
    public static final Font CHAPTER_FONT = new Font(2, 18.0f, 1, Color.GRAY);
    public static final Font TITLE_FONT = new Font(2, 14.0f, 1, Color.GRAY);
    public static final Font FOOT_FONT = new Font(2, 10.0f, 1, Color.GRAY);
    public static final Font NORMAL_FONT = new Font(2, 11.0f, 0, Color.BLACK);
    public static final Font MONOSPACED_BOLD_FONT = new Font(0, 11.0f, 1, Color.BLACK);
    public static final Font MONOSPACED_FONT = new Font(0, 10.0f, 0, Color.BLACK);
    public static final Font TOC_TITLE_FONT = new Font(1, 24.0f, 1, Color.GRAY);
    public static final Font FRONTPAGE_FONT_1 = new Font(1, 22.0f, 1, Color.BLACK);
    public static final Font FRONTPAGE_FONT_2 = new Font(1, 18.0f, 2, Color.BLACK);
    public static final Font FRONTPAGE_FONT_3 = new Font(1, 16.0f, 3, Color.GRAY);
    public static final Font UNDERLINED_FONT = new Font(1, 14.0f, 4, Color.BLACK);
    public static final Font DASHBOARD_TITLE_FONT = new Font(2, 14.0f, 1, Color.BLACK);
    public static final Font DASHBOARD_DATA_FONT = new Font(2, 14.0f, 1, Color.GRAY);
    public static final Font DASHBOARD_DATA_FONT_2 = new Font(2, 10.0f, 1, new Color(100, 150, 190));
    public static final int TENDENCY_ICONS_HEIGHT = 20;
    public static final float FRONTPAGE_LOGO_POSITION_X = 114.0f;
    public static final float FRONTPAGE_LOGO_POSITION_Y = 542.0f;

    public static void noBorderTable(PdfPTable table) {
        table.getDefaultCell().setBorderColor(Color.WHITE);
    }

    public static PdfPTable createSimpleTable(List<String> left, List<String> right, String title, String noData) {
        PdfPTable table = new PdfPTable(2);
        table.getDefaultCell().setColspan(2);
        table.addCell(new Phrase(title, DASHBOARD_TITLE_FONT));
        table.getDefaultCell().setBackgroundColor(Color.GRAY);
        table.addCell("");
        table.getDefaultCell().setColspan(1);
        table.getDefaultCell().setBackgroundColor(Color.WHITE);
        Iterator<String> itLeft = left.iterator();
        Iterator<String> itRight = right.iterator();
        while (itLeft.hasNext()) {
            String textLeft = itLeft.next();
            String textRight = itRight.next();
            table.addCell(textLeft);
            table.addCell(textRight);
        }
        if (left.isEmpty()) {
            table.getDefaultCell().setColspan(2);
            table.addCell(noData);
        }
        table.setSpacingBefore(20.0f);
        table.setSpacingAfter(20.0f);
        return table;
    }

    public static PdfPTable createTwoColumnsTitledTable(List<String> titles, List<String> content) {
        PdfPTable table = new PdfPTable(10);
        Iterator<String> itLeft = titles.iterator();
        Iterator<String> itRight = content.iterator();
        while (itLeft.hasNext()) {
            String textLeft = itLeft.next();
            String textRight = itRight.next();
            table.getDefaultCell().setColspan(1);
            table.addCell(textLeft);
            table.getDefaultCell().setColspan(9);
            table.addCell(textRight);
        }
        table.setSpacingBefore(20.0f);
        table.setSpacingAfter(20.0f);
        table.setLockedWidth(false);
        table.setWidthPercentage(90.0f);
        return table;
    }
}

