/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import org.sonar.report.pdf.Header;
import org.sonar.report.pdf.Toc;

public class Events
extends PdfPageEventHelper {
    private Toc toc;
    private Header header;

    public Events(Toc toc, Header header) {
        this.toc = toc;
        this.header = header;
        toc.setHeader(header);
    }

    public void onChapter(PdfWriter writer, Document document, float position, Paragraph paragraph) {
        this.toc.onChapter(writer, document, position, paragraph);
    }

    public void onChapterEnd(PdfWriter writer, Document document, float position) {
        this.toc.onChapterEnd(writer, document, position);
    }

    public void onSection(PdfWriter writer, Document document, float position, int depth, Paragraph paragraph) {
        this.toc.onSection(writer, document, position, depth, paragraph);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        this.header.onEndPage(writer, document);
        this.printPageNumber(writer, document);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.toc.onCloseDocument(writer, document);
    }

    private void printPageNumber(PdfWriter writer, Document document) {
        PdfContentByte cb = writer.getDirectContent();
        cb.saveState();
        float textBase = document.bottom() - 20.0f;
        try {
            cb.setFontAndSize(BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false), 12.0f);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cb.beginText();
        cb.setTextMatrix(document.right() - 10.0f, textBase);
        cb.showText(String.valueOf(writer.getPageNumber()));
        cb.endText();
        cb.saveState();
    }
}

