/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public abstract class AbstractComponentDiscoverer
implements ComponentDiscoverer {
    private ComponentDiscovererManager manager;

    protected abstract String getComponentDescriptorLocation();

    protected abstract ComponentSetDescriptor createComponentDescriptors(Reader var1, String var2) throws PlexusConfigurationException;

    public void setManager(ComponentDiscovererManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List findComponents(Context context, ClassRealm classRealm) throws PlexusConfigurationException {
        Enumeration resources;
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        try {
            resources = classRealm.getParentRealm() != null ? classRealm.findRealmResources(this.getComponentDescriptorLocation()) : classRealm.findResources(this.getComponentDescriptorLocation());
        }
        catch (IOException iOException) {
            throw new PlexusConfigurationException("Unable to retrieve resources for: " + this.getComponentDescriptorLocation() + " in class realm: " + classRealm.getId());
        }
        Enumeration e = resources;
        while (e.hasMoreElements()) {
            Object var13_14;
            URL url = (URL)e.nextElement();
            XmlStreamReader reader = null;
            try {
                try {
                    URLConnection conn = url.openConnection();
                    conn.setUseCaches(false);
                    conn.connect();
                    reader = ReaderFactory.newXmlReader((InputStream)conn.getInputStream());
                    InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)reader, (Map)new ContextMapAdapter(context));
                    ComponentSetDescriptor componentSetDescriptor = this.createComponentDescriptors((Reader)interpolationFilterReader, url.toString());
                    if (componentSetDescriptor.getComponents() != null) {
                        Iterator i = componentSetDescriptor.getComponents().iterator();
                        while (i.hasNext()) {
                            ComponentDescriptor cd = (ComponentDescriptor)i.next();
                            cd.setRealmId(classRealm.getId());
                        }
                    }
                    componentSetDescriptors.add(componentSetDescriptor);
                    ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor);
                    this.manager.fireComponentDiscoveryEvent(event);
                }
                catch (IOException ex) {
                    throw new PlexusConfigurationException("Error reading configuration " + url, ex);
                }
            }
            catch (Throwable throwable) {
                var13_14 = null;
                IOUtil.close(reader);
                throw throwable;
            }
            {
                var13_14 = null;
            }
            IOUtil.close((Reader)reader);
        }
        return componentSetDescriptors;
    }
}

