/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class TarResource
extends AbstractPlexusIoResource
implements PlexusIoResourceWithAttributes {
    private final TarFile tarFile;
    private final TarArchiveEntry entry;
    private PlexusIoResourceAttributes attributes;

    public TarResource(TarFile tarFile, TarArchiveEntry entry) {
        super(entry.getName(), TarResource.getLastModifiedTime(entry), entry.isDirectory() ? -1L : entry.getSize(), !entry.isDirectory(), entry.isDirectory(), true);
        this.tarFile = tarFile;
        this.entry = entry;
    }

    private static long getLastModifiedTime(TarArchiveEntry entry) {
        long l = entry.getModTime().getTime();
        return l == -1L ? 0L : l;
    }

    public synchronized PlexusIoResourceAttributes getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SimpleResourceAttributes(Integer.valueOf(this.entry.getUserId()), this.entry.getUserName(), Integer.valueOf(this.entry.getGroupId()), this.entry.getGroupName(), this.entry.getMode());
        }
        return this.attributes;
    }

    public synchronized void setAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    public URL getURL() throws IOException {
        return null;
    }

    public InputStream getContents() throws IOException {
        return this.tarFile.getInputStream(this.entry);
    }
}

