/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.util;

import com.canoo.webtest.util.Evaluator;

public class Expression {
    private Evaluator fEvaluator;
    private static Expression sInstance;

    public Expression() {
    }

    public Expression(Evaluator eval) {
        this.setEvaluator(eval);
    }

    public void setEvaluator(Evaluator evaluator) {
        this.fEvaluator = evaluator;
    }

    public double evaluate(String exp) {
        if (exp == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(exp);
        }
        catch (NumberFormatException e) {
            return this.evaluate(exp.toCharArray(), 0, exp.length());
        }
    }

    protected double evaluateString(String s) {
        if (this.fEvaluator != null) {
            return this.fEvaluator.evaluate(s.trim());
        }
        throw new IllegalArgumentException("Cannot parse: '" + s + "': No evaluator");
    }

    private double evaluate(char[] e, int origStart, int origEnd) {
        int start;
        int end = origEnd;
        for (start = origStart; start < end && e[start] == ' '; ++start) {
        }
        if (end == start) {
            return 0.0;
        }
        while (e[end - 1] == ' ') {
            --end;
        }
        boolean number = true;
        int bracket = 0;
        for (int add = 0; add < 2; ++add) {
            for (int i = end - 1; i >= start; --i) {
                if (e[i] == ')') {
                    ++bracket;
                } else if (e[i] == '(') {
                    --bracket;
                } else if (bracket == 0) {
                    if (add == 0) {
                        if (e[i] == '+') {
                            return this.evaluate(e, start, i) + this.evaluate(e, i + 1, end);
                        }
                        if (e[i] == '-') {
                            return this.evaluate(e, start, i) - this.evaluate(e, i + 1, end);
                        }
                    } else {
                        if (e[i] == '*') {
                            return this.evaluate(e, start, i) * this.evaluate(e, i + 1, end);
                        }
                        if (e[i] == '/') {
                            return this.evaluate(e, start, i) / this.evaluate(e, i + 1, end);
                        }
                        if (e[i] == '%') {
                            return this.evaluate(e, start, i) % this.evaluate(e, i + 1, end);
                        }
                    }
                }
                if (e[i] >= '0' && e[i] <= '9' || e[i] == '.') continue;
                number = false;
            }
        }
        if (e[end - 1] == ')' && e[start] == '(') {
            if (--end == ++start) {
                return 0.0;
            }
            return this.evaluate(e, start, end);
        }
        String s = new String(e, start, end - start);
        if (number) {
            return Double.parseDouble(s);
        }
        return this.evaluateString(s);
    }

    public static double evaluateExpression(String s) {
        return Expression.evaluateExpression(s, null);
    }

    public static double evaluateExpression(String s, Evaluator eval) {
        if (sInstance == null) {
            sInstance = new Expression(eval);
        } else {
            sInstance.setEvaluator(eval);
        }
        return sInstance.evaluate(s);
    }
}

