/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.store;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.BaseStoreStep;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.Evaluator;
import com.canoo.webtest.util.Expression;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;

public class StorePropertyStep
extends BaseStoreStep
implements Evaluator {
    private String fPropertyValue;
    private String fEval;
    private String fName;
    private File fFile;

    public void doExecute() {
        if (this.fFile == null) {
            this.addProperty(this.getName(), this.getValue());
        } else {
            this.loadProperties(this.fFile);
        }
    }

    private void addProperty(String name, String value) {
        value = this.isEval() ? this.doEvaluate(value) : value;
        this.storeProperty(value, name);
    }

    String doEvaluate(String propertyValue) {
        double d = Expression.evaluateExpression(propertyValue, this);
        if (d == (double)((int)d)) {
            return Integer.toString((int)d);
        }
        return Double.toString(d);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getValue() {
        return this.fPropertyValue;
    }

    public void setValue(String value) {
        this.fPropertyValue = value;
    }

    public boolean isEval() {
        return ConversionUtil.convertToBoolean(this.getEval(), false);
    }

    public String getEval() {
        return this.fEval;
    }

    public void setEval(String eval) {
        this.fEval = eval;
    }

    protected void verifyParameters() {
        if (this.fFile == null) {
            this.nullParamCheck(StringUtils.defaultString((String)this.getProperty(), (String)this.fName), "name");
            this.nullParamCheck(this.getValue(), "value");
        } else {
            this.paramCheck(this.fName != null, "Parameters \"name\" and \"file\" can't be set together");
            this.paramCheck(this.getValue() != null, "Parameters \"value\" and \"file\" can't be set together");
        }
    }

    public double evaluate(String s) {
        String result = this.getProject().replaceProperties(s);
        try {
            return Double.parseDouble(result);
        }
        catch (NumberFormatException e) {
            throw new StepFailedException("Attempted to evaluate non-numeric property '" + s + "': " + e.getMessage(), this);
        }
    }

    public void addText(String text) {
        this.fPropertyValue = text;
    }

    protected void loadProperties(File file) {
        Properties props = new Properties();
        this.log("Loading properties from " + file.getAbsolutePath(), 3);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
        }
        catch (IOException e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setFile(File propertiesFile) {
        this.fFile = propertiesFile;
    }
}

